#!/bin/bash

INPUT_FILE="strings_old.json"
OUTPUT_FILE="strings.json"
TEMP_DIR=$(mktemp -d)

echo "Transformation en cours..."

# Étape 1: Extraire toutes les clés
jq -r '[.fr, .en, .de, .it | keys] | flatten | unique | .[]' "$INPUT_FILE" > "$TEMP_DIR/keys.txt"

# Étape 2: Créer un objet vide pour commencer
echo '{}' > "$TEMP_DIR/result.json"

# Étape 3: Pour chaque clé, construire l'objet de traduction
while IFS= read -r key; do
    # Extraire les valeurs pour chaque langue
    fr_value=$(jq -r ".fr.\"$key\" // \"\"" "$INPUT_FILE" 2>/dev/null)
    en_value=$(jq -r ".en.\"$key\" // \"\"" "$INPUT_FILE" 2>/dev/null) 
    de_value=$(jq -r ".de.\"$key\" // \"\"" "$INPUT_FILE" 2>/dev/null)
    it_value=$(jq -r ".it.\"$key\" // \"\"" "$INPUT_FILE" 2>/dev/null)
    
    # Construire l'objet JSON pour cette clé
    key_object=$(jq -n \
        --arg key "$key" \
        --arg fr "$fr_value" \
        --arg en "$en_value" \
        --arg de "$de_value" \
        --arg it "$it_value" \
        '{
            ($key): {
                "fr": (if $fr == "" then null else $fr end),
                "en": (if $en == "" then null else $en end),
                "de": (if $de == "" then null else $de end),
                "it": (if $it == "" then null else $it end)
            }
        }')
    
    # Fusionner avec le résultat existant
    jq -s '.[0] * .[1]' "$TEMP_DIR/result.json" <(echo "$key_object") > "$TEMP_DIR/result_temp.json"
    mv "$TEMP_DIR/result_temp.json" "$TEMP_DIR/result.json"
    
done < "$TEMP_DIR/keys.txt"

# Étape 4: Trier et formater le résultat final
jq -S '.' "$TEMP_DIR/result.json" > "$OUTPUT_FILE"

# Nettoyer
rm -rf "$TEMP_DIR"

echo "✅ Transformation terminée! Fichier: $OUTPUT_FILE"

# Vérification
echo ""
echo "Vérification des premières clés:"
jq 'with_entries(select(.key | test("import_vehicle_nav|export_vehicle_nav|home_nav")))' "$OUTPUT_FILE"
