angular.module('edecApp')
    .controller('PaymentController', function($scope, $location, $window) {
        // Ce controller n'est plus utilisé avec Stripe Checkout
        // Redirection automatique vers la page d'accueil
        $location.path('/');
    });

/*
	.controller('PaymentController', function($scope, $http, $location, $window, $rootScope, $timeout, ConfigService) { // AJOUT de ConfigService

		// 🔴 CORRECTION IMPORTANTE : Remplacez par votre vraie clé Stripe
		const STRIPE_PUBLIC_KEY = 'pk_test_51SF3ZMDLAThCxOAyPFDmPowjqUJyyay34PQZu8SfEHDZaVNFSNCCPjE2dAJYpvHHtqQcR0I23gEstk9V24B83PAw00g4jIHw2r'; // Obtenez cette clé depuis votre dashboard Stripe

		$scope.loading = true;
		$scope.processing = false;
        
        // AJOUT : Nouvelles variables d'état pour le nouveau flux
        $scope.clientEmail = ''; // Nouvelle variable pour l'email en cas d'erreur plateforme
        $scope.declarationReady = !!sessionStorage.getItem('edec_pending_payload');
        $scope.paymentError = null;

		$scope.stripe = null;
		$scope.elements = null;
		$scope.paymentElement = null;
		$scope.clientSecret = null;
		$scope.destinationType = sessionStorage.getItem('edec_intended_destination') || 'import';
		$scope.paymentElementComplete = false;

		$scope.initializePayment = function() {
		  if (window.Stripe) {
			$scope.createCheckoutSession();
			return;
		  }

		  const script = document.createElement('script');
		  script.src = 'https://js.stripe.com/v3/';
		  script.onload = () => {
			$scope.$apply(() => {
			  $scope.createCheckoutSession();
			});
		  };
		  script.onerror = () => {
			$scope.$apply(() => {
			  $scope.paymentError = $rootScope.t('payment_stripe_load_error');
		  });
		};

		$scope.createCheckoutSession = function() {
			// Rediriger directement vers votre lien Stripe Checkout
			window.location.href = 'https://buy.stripe.com/test_aFa8wP5s94W70v9acuafS00';
		}
		
		$scope.initStripe = function() {
			try {
				$scope.stripe = Stripe(STRIPE_PUBLIC_KEY);
			} catch (e) {
				console.error('Erreur Stripe init:', e);
				$scope.paymentError = $rootScope.t('payment_stripe_init_error'); // Clé de traduction à ajouter
				$scope.loading = false;
				return;
			}

			// 1. Appeler le backend pour créer le Payment Intent
			$http.post('/api/create-payment-intent', { type: $scope.destinationType })
				.then(function(response) {
					$scope.clientSecret = response.data.clientSecret;
					$scope.amount = response.data.amount;
					$scope.currency = response.data.currency;
					$scope.mountPaymentElement();
				})
				.catch(function(error) {
					console.error('Erreur création Payment Intent:', error);
					$scope.paymentError = error.data && error.data.message ? error.data.message : $rootScope.t('payment_unknown_error');
					$scope.loading = false;
				});
		};

		$scope.mountPaymentElement = function() {
			if (!$scope.stripe || !$scope.clientSecret) return;

			$scope.elements = $scope.stripe.elements({
				clientSecret: $scope.clientSecret
			});

			// Configure le Payment Element
			const options = {
				layout: { type: 'tabs' }
			};
			$scope.paymentElement = $scope.elements.create('payment', options);
			$scope.paymentElement.mount('#payment-element');

			$scope.paymentElement.on('ready', () => {
				$scope.$apply(() => {
					$scope.loading = false;
				});
			});

			$scope.paymentElement.on('change', (event) => {
				$scope.$apply(() => {
					$scope.paymentElementComplete = event.complete;
				});
			});
		};

		$scope.finalizePayment = function() {
			if (!$scope.stripe || !$scope.paymentElementComplete || $scope.processing) return;

			$scope.processing = true;
			$scope.paymentError = null;

			$scope.stripe.confirmPayment({
				elements: $scope.elements,
				confirmParams: {
					// L'URL fournie ici est l'URL de retour après la confirmation (par exemple 3D Secure)
					return_url: $scope.getRedirectUrl(),
				}
			}).then(function({ error, paymentIntent }) {
				if (error) {
					console.error('Erreur de confirmation de paiement:', error);
					$scope.$apply(() => {
						$scope.paymentError = error.message || $rootScope.t('payment_unknown_error');
						$scope.processing = false;
						$scope.$emit('paymentIframeError', $scope.paymentError); // Émettre l'erreur
					});
				} else if (paymentIntent && paymentIntent.status === 'succeeded') {
					// Si la confirmation a réussi immédiatement (rare, mais possible)
					window.onPaymentSuccess({
						sessionToken: paymentIntent.id,
						paymentMethod: paymentIntent.payment_method_types[0]
					});
				}
			}).catch(function(confirmError) {
				console.error('Erreur durant la confirmation de paiement:', confirmError);
				$scope.$apply(() => {
					$scope.processing = false;
				});
			});
		};

$scope.createCheckoutSession = function() {
  $http.post('/api/create-checkout-session', {
    type: $scope.destinationType
  })
  .then(function(response) {
    // Rediriger vers la page de checkout Stripe
    window.location.href = response.data.url;
  })
  .catch(function(error) {
    $scope.paymentError = error.data?.error || $rootScope.t('payment_unknown_error');
  });
};

		// NOUVELLE FONCTION de soumission post-paiement (remplacement de l'ancienne)
		window.onPaymentSuccess = function(details) {
			$scope.processing = true;
			$scope.$apply();

			const pendingPayload = sessionStorage.getItem('edec_pending_payload');
			if (!pendingPayload) {
				// Pas de déclaration en attente, renvoyer l'utilisateur à la page d'accueil ou de paiement vide.
				$location.path('/payment');
				$scope.$apply();
				return;
			}

			const payload = JSON.parse(pendingPayload);

			// Étape 4 : Soumission réelle à la plateforme de la douane
			$http.post(ConfigService.getApiConfig().declaration_submit_url, {
				paymentDetails: details,
				declaration: payload.declaration,
				destinationType: $scope.destinationType,
				clientEmail: $scope.clientEmail || null, // Ajout de l'email
			})
			.then(function(response) {
				if (response.data.success) {
					sessionStorage.removeItem('edec_pending_payload'); // Nettoyer le payload en attente
					// Stocker la preuve de paiement (pour éviter la re-soumission)
					localStorage.setItem('edec_payment_proof', JSON.stringify(response.data.paymentProof));
					$location.path('/payment-success');
				} else if (response.data.submissionPlatformError) {
					// Afficher l'erreur de plateforme avec demande d'email (si non déjà rempli)
					$scope.paymentError = $rootScope.t('submission_platform_error');
				} else {
					// Erreur générique
					$scope.paymentError = response.data.message || $rootScope.t('payment_unknown_error');
				}
			})
			.catch(function(error) {
				$scope.paymentError = error.data && error.data.message ? error.data.message : $rootScope.t('payment_unknown_error');
			})
			.finally(function() {
				$scope.processing = false;
				$scope.$apply();
			});
		};

        // AJOUT : Fonctions d'interaction utilisateur (Edit/Retry)
        $scope.retryPayment = function() {
            $scope.paymentError = null;
            $scope.processing = false;
            // Réinitialise l'élément pour une nouvelle tentative si nécessaire, ou se fie au bouton Stripe pour recommencer.
        };

        $scope.editDeclaration = function() {
            sessionStorage.removeItem('edec_pending_payload'); // Nettoyer la déclaration en attente
            $location.path('/' + $scope.destinationType); // Rediriger vers Import ou Export
        };

		$scope.getRedirectUrl = function() {
		  return $window.location.origin + '/payment-success';
		};

        // AJOUT : Écouteur pour récupérer les erreurs de l'iframe de paiement (si non géré par onPaymentSuccess)
        $scope.$on('paymentIframeError', function(event, message) {
            $scope.paymentError = message || $rootScope.t('payment_unknown_error');
            $scope.$apply(); // force l'update du scope pour afficher l'erreur
        });
        
		$scope.verifyExistingPayment = function(paymentId) {
			$http.post('/api/verify-payment', {
					paymentIntentId: paymentId
				})
				.then(function(response) {
					if (response.data.valid) {
						$rootScope.showNotification($rootScope.t('payment_already_valid'), 'success');
						$timeout(() => {
							$location.path('/' + $scope.destinationType);
						}, 1500);
					} else {
						localStorage.removeItem('edec_payment_proof');
						$scope.initializePayment();
					}
				})
				.catch(function(error) {
					console.error('Erreur vérification paiement:', error);
					localStorage.removeItem('edec_payment_proof');
					$scope.initializePayment();
				});
		};

		$scope.goBack = function() {
			sessionStorage.removeItem('edec_intended_destination');
			$location.path('/');
		};

		// 🌟 CORRECTION : Initialiser le paiement après le rendu de la vue
		$scope.$on('$viewContentLoaded', function() {
		  const existingPayment = localStorage.getItem('edec_payment_proof');
		  if (existingPayment && $scope.declarationReady) {
            // Si l'utilisateur arrive ici, c'est qu'il a déjà payé ET qu'il a une déclaration en attente (cas rare, mais possible)
            // On le redirige vers le succès pour relancer la soumission (gérée dans onPaymentSuccess)
            $location.path('/payment-success');
		  } else {
			// Si pas de paiement existant ou pas de déclaration prête, on lance l'initialisation du paiement standard
			$scope.initializePayment();
		  }
		});
	});
	
*/