#!/bin/bash

# Nom du fichier de sortie
OUTPUT_FILE="project_context.txt"

# Dossiers et fichiers à inclure
TARGET_PATHS=("server" "public" "package.json")

# Fichiers et dossiers à ignorer (ajoutez ici tout ce qui est binaire, logs, ou configuration non essentielle)
EXCLUDE_PATTERNS=(
    "node_modules"
    "logs"
    "backup"
    ".git"
    "*.log"
    "*.lock"
    "*.swp"
    "*.map"
    "*.jpg"
    "*.png"
    "*.gif"
    "*.ico"
    "*.eot"
    "*.ttf"
    "*.woff"
    "*.woff2"
    "*.svg"
    "*.min.js"
    "*.min.css"
)

# --- Début du script ---

# Supprimer le fichier de sortie précédent s'il existe
rm -f "$OUTPUT_FILE"

echo "Génération du fichier de contexte pour le projet..."
echo "Le résultat sera enregistré dans : $OUTPUT_FILE"
echo "" >> "$OUTPUT_FILE"

# Fonction pour vérifier si un fichier doit être ignoré
should_exclude() {
    local path="$1"
    for pattern in "${EXCLUDE_PATTERNS[@]}"; do
        if [[ "$path" == *"$pattern"* ]]; then
            return 0 # Oui, exclure
        fi
    done
    return 1 # Non, inclure
}

# Traiter chaque chemin cible (dossier ou fichier)
for TARGET in "${TARGET_PATHS[@]}"; do
    if [ -d "$TARGET" ]; then
        # C'est un répertoire : utiliser find pour la récursion
        find "$TARGET" -type f | while read FILE_PATH; do
            if ! should_exclude "$FILE_PATH"; then
                echo "Ajout de: $FILE_PATH"
                echo "----------------------------------------------------" >> "$OUTPUT_FILE"
                echo "$FILE_PATH" >> "$OUTPUT_FILE"
                echo "" >> "$OUTPUT_FILE"
                # Insérer le contenu du fichier
                cat "$FILE_PATH" >> "$OUTPUT_FILE"
                echo "" >> "$OUTPUT_FILE" # Ajouter une ligne vide pour la séparation
            fi
        done
    elif [ -f "$TARGET" ]; then
        # C'est un fichier unique
        if ! should_exclude "$TARGET"; then
            echo "Ajout de: $TARGET"
            echo "----------------------------------------------------" >> "$OUTPUT_FILE"
            echo "$TARGET" >> "$OUTPUT_FILE"
            echo "" >> "$OUTPUT_FILE"
            # Insérer le contenu du fichier
            cat "$TARGET" >> "$OUTPUT_FILE"
            echo "" >> "$OUTPUT_FILE" # Ajouter une ligne vide pour la séparation
        fi
    else
        echo "Avertissement: Le chemin cible '$TARGET' n'existe pas."
    fi
done

echo ""
echo "Terminé ! Le contexte complet est dans $OUTPUT_FILE"
