/* ------------------
	JS - localStorage
--------------------*/
$(document).ready(function() {
  $("#pl-6").owlCarousel({
    slideSpeed: 300,
    paginationSpeed: 400,
    singleItem: true,
    autoPlay: true
  });
  productsDisplay();
});

function openShop() {
  if (localStorage.user) {
    window.location.href = 'products.html';
  } else {
    window.location.href = 'login.html';
  }
}

function productsDisplay() {
  var items = "";
  $.ajax({
    url: '../../../particuliers/api/products',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var products = response;
      $(products).each(function(index) {
        if (this.isFeatured == 1 && this.isActive == 1) {
          items += '<div class="product-item column">' + '<div class="product-preview-actions">' + '<figure class="product-preview-image">' + '<img src="images/items/image' + this.productId + '_m.jpg" alt="product-image">' + '</figure>' + '</div>' + '<div class="product-info">' + '<a href="login.html">' + '<p class="text-header">' + this.designation + '</p>' + '</a>' + '<p class="product-description">' + this.description + '</p>' + '<a href="services.html">' + '<p class="category primary">' + this.category + '</p>' + '</a>' + '<p class="price"><span>CHF </span>' + parseFloat(this.price).toFixed(2) + '</p>' + '</div>' + '</div>';
        }
      });
      $('.product-list').html(items);
      var productCarousel_1 = '#pl-1',
        productCarousel_2 = '#pl-2',
        productCarousel_3 = '#pl-3',
        productCarousel_4 = '#pl-4',
        productCarousel_5 = '#pl-5';
      var defaults = {
        items: 4,
        itemWidth: 300,
        itemsDesktop: [1260, 3],
        itemsTablet: [930, 2],
        itemsMobile: [620, 1],
        navigation: true,
        navigationText: false
      }
      $(productCarousel_1).owlCarousel(defaults);
      $(productCarousel_2).owlCarousel(defaults);
      $(productCarousel_3).owlCarousel(defaults);
      $(productCarousel_4).owlCarousel(defaults);
      $(productCarousel_5).owlCarousel(defaults);

      function nextSlide(e) {
        e.preventDefault();
        e.data.owlObject.next();
      }

      function prevSlide(e) {
        e.preventDefault();
        e.data.owlObject.prev();
      }

      function registerCarousels(carousels) {
        for (var i = 0; i < carousels.length; i++) {
          var id = carousels[i],
            owl = $(id).data('owlCarousel');
          $(id).parent().find('.slide-control.right').on('click', {
            owlObject: owl
          }, nextSlide);
          $(id).parent().find('.slide-control.left').on('click', {
            owlObject: owl
          }, prevSlide);
        }
      }
      var carousels = [productCarousel_1, productCarousel_2, productCarousel_3, productCarousel_4, productCarousel_5];
      registerCarousels(carousels);
    }
  })
}
/* ------------------
	PHP - session
--------------------*/
/*
var user;
$.ajax({
  url: '../../../particuliers/api/session/user',
  type: 'GET',
  dataType: "json",
  success: function(response) {
    if (response.username) {
      user = response;
  }
})
$(document).ready(function() {
  $("#pl-6").owlCarousel({
    slideSpeed: 300,
    paginationSpeed: 400,
    singleItem: true,
    autoPlay: true
  });
  productsDisplay();
});

function openShop() {
  if (user) {
    window.location.href = 'products.html';
  } else {
    window.location.href = 'login.html';
  }
}

function productsDisplay() {
  var items = "";
  $.ajax({
    url: '../../../particuliers/api/products',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var products = response;
      $(products).each(function(index) {
        if (this.isFeatured == 1 && this.isActive == 1) {
          items += '<div class="product-item column">' + '<div class="product-preview-actions">' + '<figure class="product-preview-image">' + '<img src="images/items/logos_m.jpg" alt="product-image">' + '</figure>' + '</div>' + '<div class="product-info">' + '<a href="service-page.html">' + '<p class="text-header">' + this.designation + '</p>' + '</a>' + '<p class="product-description">' + this.description + '</p>' + '<a href="services.html">' + '<p class="category primary">' + this.category + '</p>' + '</a>' + '<p class="price"><span>CHF </span>' + parseFloat(this.price).toFixed(2) + '</p>' + '</div>' + '</div>';
        }
      });
      $('.product-list').html(items);
      var productCarousel_1 = '#pl-1',
        productCarousel_2 = '#pl-2',
        productCarousel_3 = '#pl-3',
        productCarousel_4 = '#pl-4',
        productCarousel_5 = '#pl-5';
      var defaults = {
        items: 4,
        itemWidth: 300,
        itemsDesktop: [1260, 3],
        itemsTablet: [930, 2],
        itemsMobile: [620, 1],
        navigation: true,
        navigationText: false
      }
      $(productCarousel_1).owlCarousel(defaults);
      $(productCarousel_2).owlCarousel(defaults);
      $(productCarousel_3).owlCarousel(defaults);
      $(productCarousel_4).owlCarousel(defaults);
      $(productCarousel_5).owlCarousel(defaults);

      function nextSlide(e) {
        e.preventDefault();
        e.data.owlObject.next();
      }

      function prevSlide(e) {
        e.preventDefault();
        e.data.owlObject.prev();
      }

      function registerCarousels(carousels) {
        for (var i = 0; i < carousels.length; i++) {
          var id = carousels[i],
            owl = $(id).data('owlCarousel');
          $(id).parent().find('.slide-control.right').on('click', {
            owlObject: owl
          }, nextSlide);
          $(id).parent().find('.slide-control.left').on('click', {
            owlObject: owl
          }, prevSlide);
        }
      }
      var carousels = [productCarousel_1, productCarousel_2, productCarousel_3, productCarousel_4, productCarousel_5];
      registerCarousels(carousels);
    }
  })
}
*/
