import os
import mysql.connector
from jinja2 import Environment, FileSystemLoader
from weasyprint import HTML
from datetime import datetime

# Se connecter à la base de données
conn = mysql.connector.connect(
    host='localhost',
    user='lepalmier',
    password='benlow',
    database='particuliers_db'
)

# Créer un curseur pour exécuter des requêtes
cursor = conn.cursor(dictionary=True)

# Récupérer les données nécessaires de la base de données
query = """
SELECT o.orderId, o.clientName, o.street, o.postalCode, o.city, o.date, a.designation, a.price, a.tva, a.quantity
FROM orders o
JOIN articles a ON o.orderId = a.orderId
"""
cursor.execute(query)
results = cursor.fetchall()

# Ajouter la fonction de filtre pour le formatage de la date
def format_date(date_string, format_string):
    date = datetime.strptime(date_string, '%Y-%m-%d')
    return date.strftime(format_string)

def format_year(date_string, format_string):
    date = datetime.strptime(date_string, '%Y')
    return date.strftime(format_string)

# Charger le modèle HTML
env = Environment(loader=FileSystemLoader('.'))
env.filters['format_date'] = format_date
env.filters['format_year'] = format_year
template = env.get_template('invoice.html')

# Générer les factures PDF pour chaque orderId
for row in results:
    order_id = row['orderId']
    if order_id < 1755:  # Ajouter cette ligne
        continue
    client_name = row['clientName']
    street = row['street']
    postal_code = row['postalCode']
    city = row['city']
    date = row['date'].strftime('%Y-%m-%d')
    articles = []
    total_ht = 0.0
    total_tva = 0.0
    total_ttc = 0.0

    # Calculer les totaux
    for article in results:
        if article['orderId'] == order_id:
            designation = article['designation']
            price = article['price']
            tva = article['tva']
            quantity = article['quantity']
            total = price * quantity
            total_ht += total
            total_tva += (total * tva) / 100
            total_ttc += total + ((total * tva) / 100)
            articles.append({
                'designation': designation,
                'price': price,
                'tva': tva,
                'quantity': quantity,
                'total': total
            })

    # Calculer les totaux en francs et centimes
    total_francs = int(total_ttc)
    total_centimes = int(round((total_ttc - total_francs) * 100))

    # Remplir les données dans le modèle HTML
    html_content = template.render(
        order={
            'orderId': order_id,
            'clientName': client_name,
            'street': street,
            'postalCode': postal_code,
            'city': city,
            'date': date
        },
        articles=articles,
        base7=0.0,  # Remplir les valeurs correctes pour base7 et tva7 si nécessaire
        tva7=0.0,
        base2=total_ht,
        tva2=total_tva,
        totalHT=total_ht,
        totalTVA=total_tva,
        totalTTC=total_ttc,
        totalFrancs=total_francs,
        totalCentimes=total_centimes
    )

    # Générer le fichier PDF de la facture
    file_name = f"facture_{order_id}.pdf"
    file_path = os.path.join("factures_pdf", file_name)
    HTML(string=html_content).write_pdf(file_path)

# Fermer la connexion à la base de données
cursor.close()
conn.close()
