/* ------------------
	JS - localStorage
--------------------*/
if (!localStorage.user) {
  window.location.href = 'login.html';
}

$(document).ready(function() {
  userDisplay();
  basketDisplay();
  cartDisplay();
});

function cartCheckout() {

  var totalHT = 0;
  var tva2 = 0;
  var tva7 = 0;
  var totalTTC = 0;
  var user = JSON.parse(localStorage.getItem('user'));
  if (localStorage.basket) {
    var basket = JSON.parse(localStorage.getItem('basket'));
  } else {
    var basket = [];
  }
  if (basket.length != 0) {
    $(basket).each(function(index) {;
      totalTTC += this.price * this.quantity;
	if (this.TVA == "5.5"){
		tva2 += (this.price * this.quantity) / (1+5.5/100);
	} else if (this.TVA == "20.0"){
		tva7 += (this.price * this.quantity) / (1+20/100);
	}
    })
    totalHT = totalTTC - tva2 - tva7;	
    $.ajax({
      url: '../../../particuliers/api/order/add',
      type: 'POST',
      dataType: "json",
      contentType: "application/json; charset=utf-8",
      data: JSON.stringify({
        "basket": basket,
        "companyName": user.companyName,
        "street": user.street,
        "postalCode": user.postalCode,
        "city": user.city,
        "total": parseFloat(totalTTC).toFixed(2)
      }),
      success: function(response) {
        if (response.notice) {
		  $('#orderId').html(response.orderId);
		  invoicExport();  
        }
      }
    })
  } else {
    alert('panier vide');
  }
}

function cartDisplay() {
  if (localStorage.basket) {
    var basket = JSON.parse(localStorage.getItem('basket'));
  } else {
    var basket = [];
  }
  var user = JSON.parse(localStorage.getItem('user'));
  var totalHT = 0;
  var tva2 = 0;
  var base2 = 0;
  var tva7 = 0;
  var base7 = 0;
  var totalTTC = 0;
  var totalTVA = 0;
  var items = "";
  var items2 = "";
  var items3 = "";
  $(basket).each(function(index) {
    items += '<div class="cart-item">' + '<div class="cart-item-product">' + '<div class="item-preview">' + '<a>' + '<figure class="product-preview-image small liquid">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '</a>' + '<p class="text-header small">' + this.designation + '</p>' + '<p class="description">' + this.description + '</p>' + '</div>' + '</div>' + '<div class="cart-item-category">' + '<input type="number" min="1" data-index="' + index + '" value="' + this.quantity + '">' + '</div>' + '<div class="cart-item-price">' + '<p class="price">' + parseFloat(this.price * this.quantity).toFixed(2) + '<span> €</span></p>' + '</div>' + '<div class="cart-item-actions">' + '<a href="javascript:basketDeleteItem(' + this.productId + ');" class="button dark-light rmv">' + '<svg class="svg-plus">' + '<use xlink:href="#svg-plus"></use>' + '</svg>' + '</a>' + '</div>' + '</div>';
    totalTTC += this.price * this.quantity;
	if (this.TVA == "5.5"){
		tva = 5.5;
		base2 += (this.price * this.quantity)/(1+5.5/100);
	} else if (this.TVA == "20.0"){
		tva = 20;
		base7 += (this.price * this.quantity)/(1+20/100);
	}
	if(index >= 38 /*19*/) {
	items2 += '<tr>' + '<td class="desc">' + this.designation + ' </td>' + '<td class="unit">' + parseFloat(this.price).toFixed(2) + '</td>' + '<td class="qty">' + this.quantity + '</td>' + '<td class="total">' + parseFloat(this.price * this.quantity).toFixed(2) + '</td>' + '<td class="tva">' + tva + '%</td>' + '</tr>';
	} else  {
	items3 += '<tr>' + '<td class="desc">' + this.designation + ' </td>' + '<td class="unit">' + parseFloat(this.price).toFixed(2) + '</td>' + '<td class="qty">' + this.quantity + '</td>' + '<td class="total">' + parseFloat(this.price * this.quantity).toFixed(2) + '</td>' + '<td class="tva">' + tva + '%</td>' + '</tr>';
	}
  });
  tva2 = (base2 * 5.5) / 100;
  tva7 = (base7 * 20) / 100;
  totalHT = totalTTC - tva2 - tva7;
  totalTVA = tva2 + tva7;
  totalFrancs = NumberToLetter(Math.floor(totalTTC));
  totalCentimes = NumberToLetter(parseInt(totalTTC.toFixed(2).toString().split(".")[1]));
  var content = '<div class="cart">' + '<div class="cart-header">' + '<div class="cart-header-product">' + '<p class="text-header small">Produit</p>' + '</div>' + '<div class="cart-header-category">' + '<p class="text-header small">Quantité</p>' + '</div>' + '<div class="cart-header-price">' + '<p class="text-header small">Prix</p>' + '</div>' + '<div class="cart-header-actions">' + '<p class="text-header small"></p>' + '</div>' + '</div>' + items + '<div class="cart-total">' + '<p class="price medium">' + parseFloat(totalHT).toFixed(2) + '<span> €</span></p>' + '<p class="text-header total">Total HT</p>' + '</div>' + '<div class="cart-total">' + '<p class="price medium">' + parseFloat(tva2).toFixed(2) + '<span> €</span></p>' + '<p class="text-header total">TVA 5.5% </p>' + '</div>' + '<div class="cart-total">' + '<p class="price medium">' + parseFloat(tva7).toFixed(2) + '<span> €</span></p>' + '<p class="text-header total">TVA 20% </p>' + '</div>' + '<div class="cart-total">' + '<p class="price medium">' + parseFloat(totalTTC).toFixed(2) + '<span> €</span></p>' + '<p class="text-header total">Total TTC</p>' + '</div>' + '<div class="cart-actions">' + '<a href="javascript:cartCheckout();" class="button mid primary">Valider</a>' + '<a href="products.html" class="button mid dark-light spaced">Retour</a>' + '</div>' + '</div>';
  $('.jq-cart-content').html(content);
  var date = new Date();
  var day = date.getDate();
  if (day < 10) {
    day = "0" + day;
  }
  var month = date.getMonth() + 1;
  if (month < 10) {
    month = "0" + month;
  }
  var year = date.getFullYear();
  var invoice = '<header class="clearfix">'
    +'<div id="project">'
      +'PMARKET SASU' 
	  + '<br>37 Rue Joseph Marion' 
	  + '<br>01200 Valserhône' 
	  + '<br>TVA: FR57893553636'
	  + '<br>SIRET: 89355363600018'
	  + '<br>contact@p-market.fr'
	  + '<br>06 05 78 77 12'
   +'</div>'
    +'<div id="slogan" class="clearfix">'
      +'Osez l&apos;originalit&eacute;'
    +'</div>'
    +'<div class="clearfix"></div>'
    +'<div id="contact">'
    +'</div>'
    +'<div id="company">'
      + user.companyName
      +'<br>' +user.street
      +'<br>'+user.postalCode+' '+user.city
    +'</div>'
    +'<div class="clearfix"></div>'
    +'<div id="facture">'
      +'Facture proforma n&ordm; '
    +'</div>'
    +'<div id="date">'
      +'Date: '+day+'.'+month+'.'+year 
    +'</div>'
  +'</header>'
  +'<main>'
    +'<table id="order">'
      +'<thead>'
        +'<tr>'
          +'<th class="desc">D&eacute;signation</th>'
          +'<th class="unit">Prix unit.</th>'
          +'<th class="qty">Qt&eacute;</th>'
          +'<th class="total">Montant</th>'
          +'<th class="tva">TVA</th>'
        +'</tr>'
      +'</thead>'
      +'<tbody>'
        + items3
    +'</tbody>'
    +'<table id="order">'
      +'<tbody>'
        + items2
    +'</tbody>'
  +'</table>'
  +'<div class="clearfix"></div>'
  +'<div id="tva">'
    +'<span>D&eacute;tail TVA:</span>'
    +'<table>'
      +'<thead>'
        +'<tr>'
          +'<th>Base</th>'
          +'<th>Taux</th>'
          +'<th>TVA</th>'
        +'</tr>'
      +'</thead>'
      +'<tbody>'
        +'<tr>'
          +'<td>'+parseFloat(base7).toFixed(2)+'</td>'
          +'<td>20%</td>'
          +'<td>'+parseFloat(tva7).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td>'+parseFloat(base2).toFixed(2)+'</td>'
          +'<td>5.5%</td>'
          +'<td>'+parseFloat(tva2).toFixed(2)+'</td>'
        +'</tr>'
      +'</tbody>'
    +'</table>'
  +'</div>'
  +'<div id="montant">'
    +'<table>'
      +'<tbody>'
        +'<tr>'
          +'<td class="first">Total net</td>'
          +'<td class="last">'+parseFloat(totalHT).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td class="first">TVA</td>'
          +'<td  class="last">'+parseFloat(totalTVA).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td class="first">Montant total TTC</td>'
          +'<td  class="last">'+parseFloat(totalTTC).toFixed(2)+'</td>'
        +'</tr>'
      +'</tbody>'
    +'</table>'
    +'<span>'+totalFrancs+' francs et '+totalCentimes+' centimes</span>'
  +'</div>'
  +'<div class="clearfix"></div>'
  +'<div id="notices">'
      +'Compte POSTFINANCE IBAN CH59 0900 0000 1451 3853 5<br>Avec nos meilleurs remerciements pour votre commande.'
    +'<br>contact@lepalmier-distribution.ch'
  +'</div>'
+'</main>';

  $('#invoice').html(invoice);
  $('input').on("change", function() {
    var index = $(this).data("index");
	var quantity = $(this).val();
	var basketStorage = JSON.parse(localStorage.getItem('basket'));
	basketStorage[index].quantity = quantity;
	localStorage.setItem('basket', JSON.stringify(basketStorage));
    basketDisplay();
	cartDisplay();
  });
}

function invoicExport() {
	if ($("#order:nth-child(2) tbody tr").length == 0) {
		$("#order:nth-child(2)").hide();
		$("#invoice").css("height", "29.7cm");
	} else {
		$("#order:nth-child(2)").show();
		$("#order:nth-child(2)").css("margin-top", "6cm");
		$("#invoice").css("height", "59.4cm");
	} 
	$('.section-wrap').hide();
	window.print();

//$('#invoice').printThis();
	setTimeout(function(){window.location.href = 'checkout.html'; }, 1000);	

}

function basketDisplay() {
  if (localStorage.basket) {
    var basket = JSON.parse(localStorage.getItem('basket'));
  } else {
    var basket = [];
  }
  var total = 0;
  var items = "";
  $('.jq-basket-count').html(basket.length);
  $(basket).each(function(index) {
    items += '<li class="dropdown-item">' + '<a class="link-to"></a>' + '<figure class="product-preview-image tiny">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '<p class="text-header tiny">' + this.designation + '</p>' + '<p class="category tiny primary">x ' + this.quantity + '</p>' + '<p class="price tiny">' + parseFloat(this.price * this.quantity).toFixed(2) + '<span> €</span></p>' + '</li>';
    total += this.price * this.quantity;
  });
  items += '<li class="dropdown-item">' + '<p class="text-header tiny">Total</p>' + '<p class="price">' + parseFloat(total).toFixed(2) + '<span> €</span></p>' + '<a href="cart.html" class="button primary">Aller au panier</a>' + '</li>';
  $('.jq-basket-content').html(items);
}

function basketDeleteItem(productId) {
  var basketStorage = JSON.parse(localStorage.getItem('basket'));
  var basketFilterm = basketStorage.filter(function(n) {
    return n.productId == productId;
  });
  var index = basketStorage.indexOf(basketFilterm[0]);
  basketStorage.splice(index, 1);
  localStorage.setItem('basket', JSON.stringify(basketStorage));
  basketDisplay();
  cartDisplay();
}

function userDisplay() {
  var user = JSON.parse(localStorage.getItem('user'));
  $('.jq-username').html(user.username);
  $('.jq-company-name').html(user.companyName);
}

function logout() {
  localStorage.clear();
  window.location.href = 'login.html';
}
