/* ------------------
	JS - localStorage
--------------------*/
if (!localStorage.user) {
  window.location.href = 'login.html';
}

$(document).ready(function() {
  userDisplay();
  basketDisplay();
  ordersDisplay();
});

function pagination() {
  var numberOfItems = $(".inbox-message:visible").length;
  var limitPerPage = 10;
  var totalPages = Math.ceil(Number(numberOfItems / limitPerPage));
  var items = "";
  $('.inbox-message:visible:gt(' + (limitPerPage - 1) + ')').hide();
  if (numberOfItems != 0) {
    items += '<div class="pager-item active"><p>1</p></div>';
  }
  for (var i = 2; i <= totalPages; i++) {
    items += '<div class="pager-item"><p>' + i + '</p></div>';
  }
  $('.pager').html(items);
  $(".pager-item").on("click", function() {
    if ($(this).hasClass('active')) {
      return false;
    } else {
      var currentPage = $(this).index() + 1;
      $(".pager-item").removeClass('active');
      $(this).addClass('active');
      $(".inbox-message").hide();
      var grandTotal = limitPerPage * currentPage;
      for (var i = grandTotal - limitPerPage; i < grandTotal; i++) {
        $(".inbox-message:eq(" + i + ")").show();
      }
    }
  });
}

function ordersDisplay() {
  var user = JSON.parse(localStorage.getItem('user'));
  var items = "";
  var state;
  $.ajax({
    url: "https://lepalmier-distribution.ch/medical/api/orders/client/" + encodeURIComponent(user.companyName),
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var orders = response;
      $(orders).each(function(index) {
		var date = new Date(this.date);
		var year = date.getFullYear();  
        if (this.state != 2) {
          state = '<img src="images/dashboard/star-empty.png" class="visible" alt="star-empty">';
        } else {
          state = '<img src="images/dashboard/star-filled.png" class="visible" alt="star-filled">';
        }
        items += '<div class="inbox-message">' + '<div class="inbox-message-actions">' + '<div class="starred">' + state + '</div>' + '</div>' + '<div class="inbox-message-author">' + '<p class="text-header">Ref. ' + year + '-' + this.orderId + '<span class="message-icon icon-envelope-open"></span>' + '</p>' + '</div>' + '<div class="inbox-message-content">' + '<p class="text-header normal"></p>' + '<p class="description">' + this.date + '</p>' + '</div>' + '<div class="inbox-message-type">' + '<a href="order.html#' + this.orderId + '"><span class="message-icon icon-plus"></span></a>' + '</div>' + '<div class="inbox-message-date">' + '<p><span>CHF</span>' + parseFloat(this.total).toFixed(2) + '</p>' + '</div>' + '</div>';
      });
      var content = items + '<div class="pager-wrap">' + '<div class="pager primary">' + '<div class="pager-item"><p>1</p></div>' + '<div class="pager-item active"><p>2</p></div>' + '<div class="pager-item"><p>3</p></div>' + '<div class="pager-item"><p>...</p></div>' + '<div class="pager-item"><p>17</p></div>' + '</div>' + '</div>';
      $('.jq-orders-list').html(content);
	  pagination();
    }
  })
}

function basketDisplay() {
  if (localStorage.basket) {
    var basket = JSON.parse(localStorage.getItem('basket'));
  } else {
    var basket = [];
  }
  var total = 0;
  var items = "";
  $('.jq-basket-count').html(basket.length);
  $(basket).each(function(index) {
    items += '<li class="dropdown-item">' + '<a class="link-to"></a>' + '<figure class="product-preview-image tiny">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '<p class="text-header tiny">' + this.designation + '</p>' + '<p class="category tiny primary">x ' + this.quantity + '</p>' + '<p class="price tiny">' + parseFloat(this.price * this.quantity).toFixed(2) + '<span> CHF</span></p>' + '</li>';
    total += this.price * this.quantity;
  });
  items += '<li class="dropdown-item">' + '<p class="text-header tiny">Total</p>' + '<p class="price">' + parseFloat(total).toFixed(2) + '<span> CHF</span></p>' + '<a href="cart.html" class="button primary">Aller au panier</a>' + '</li>';
  $('.jq-basket-content').html(items);
}

function userDisplay() {
  var user = JSON.parse(localStorage.getItem('user'));
  $('.jq-username').html(user.username);
  $('.jq-company-name').html(user.companyName);
}

function logout() {
  localStorage.clear();
  window.location.href = 'login.html';
}

/* ------------------
	PHP - session
--------------------*/
/*
var user;
var basket;
  $.ajax({
    url: 'https://lepalmier-distribution.ch/medical/api/session/user',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(response.error) {  
		window.location.href = 'login.html';
	  } else {
		  user = response;
 userDisplay();
  ordersDisplay();

	  }
    }
  })
  $.ajax({
    url: 'https://lepalmier-distribution.ch/medical/api/session/basket',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(!response.error) {  
				  basket = response;

	  } else {
    basket = [];
  }
    basketDisplay();

    }
  })

function pagination() {
  var numberOfItems = $(".inbox-message:visible").length;
  var limitPerPage = 10;
  var totalPages = Math.ceil(Number(numberOfItems / limitPerPage));
  var items = "";
  $('.inbox-message:visible:gt(' + (limitPerPage - 1) + ')').hide();
  if (numberOfItems != 0) {
    items += '<div class="pager-item active"><p>1</p></div>';
  }
  for (var i = 2; i <= totalPages; i++) {
    items += '<div class="pager-item"><p>' + i + '</p></div>';
  }
  $('.pager').html(items);
  $(".pager-item").on("click", function() {
    if ($(this).hasClass('active')) {
      return false;
    } else {
      var currentPage = $(this).index() + 1;
      $(".pager-item").removeClass('active');
      $(this).addClass('active');
      $(".inbox-message").hide();
      var grandTotal = limitPerPage * currentPage;
      for (var i = grandTotal - limitPerPage; i < grandTotal; i++) {
        $(".inbox-message:eq(" + i + ")").show();
      }
    }
  });
}

function ordersDisplay() {
  var items = "";
  var state;
  $.ajax({
    url: 'https://lepalmier-distribution.ch/medical/api/orders/client/' + user.companyName,
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var orders = response;
      $(orders).each(function(index) {
		var date = new Date(this.date);
		var year = date.getFullYear();
        if (this.state != 2) {
          state = '<img src="images/dashboard/star-empty.png" class="visible" alt="star-empty">';
        } else {
          state = '<img src="images/dashboard/star-filled.png" class="visible" alt="star-filled">';
        }
        items += '<div class="inbox-message">' + '<div class="inbox-message-actions">' + '<div class="starred">' + state + '</div>' + '</div>' + '<div class="inbox-message-author">' + '<p class="text-header">Ref. ' + year + '-' + this.orderId + '<span class="message-icon icon-envelope-open"></span>' + '</p>' + '</div>' + '<div class="inbox-message-content">' + '<p class="text-header normal"></p>' + '<p class="description">' + this.date + '</p>' + '</div>' + '<div class="inbox-message-type">' + '<a href="order.html#' + this.orderId + '"><span class="message-icon icon-plus"></span></a>' + '</div>' + '<div class="inbox-message-date">' + '<p><span>$</span>' + parseFloat(this.total).toFixed(2) + '</p>' + '</div>' + '</div>';
      });
      var content = items + '<div class="pager-wrap">' + '<div class="pager primary">' + '<div class="pager-item"><p>1</p></div>' + '<div class="pager-item active"><p>2</p></div>' + '<div class="pager-item"><p>3</p></div>' + '<div class="pager-item"><p>...</p></div>' + '<div class="pager-item"><p>17</p></div>' + '</div>' + '</div>';
      $('.jq-orders-list').html(content);
	  pagination();
    }
  })
}

function basketDisplay() {
  var total = 0;
  var items = "";
  $('.jq-basket-count').html(basket.length);
  $(basket).each(function(index) {
    items += '<li class="dropdown-item">' + '<a class="link-to"></a>' + '<figure class="product-preview-image tiny">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '<p class="text-header tiny">' + this.designation + '</p>' + '<p class="category tiny primary">x ' + this.quantity + '</p>' + '<p class="price tiny"><span>$</span>' + parseFloat(this.price * this.quantity).toFixed(2) + '</p>' + '</li>';
    total += this.price * this.quantity;
  });
  items += '<li class="dropdown-item">' + '<p class="text-header tiny">Total</p>' + '<p class="price"><span>$</span>' + parseFloat(total).toFixed(2) + '</p>' + '<a href="cart.html" class="button primary">Aller au panier</a>' + '</li>';
  $('.jq-basket-content').html(items);
}

function userDisplay() {
  $('.jq-username').html(user.username);
  $('.jq-company-name').html(user.companyName);
}

function logout() {
  $.ajax({
    url: 'https://lepalmier-distribution.ch/medical/api/session/destroy',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(response.notice) {  
		window.location.href = 'login.html';
	  }
    }
  })
}
*/