/* ------------------
	JS - localStorage
--------------------*/
if (!localStorage.user) {
  window.location.href = 'login.html';
}

$(document).ready(function() {
  userDisplay();
  basketDisplay();
  articlesDisplay();
});

function articlesDisplay() {
  var orderId = window.location.hash.substr(1);
  var user = JSON.parse(localStorage.getItem('user'));
  var totalHT = 0;
  var tva2 = 0;
  var base2 = 0;
  var tva7 = 0;
  var base7 = 0;
  var totalTVA = 0;
  var totalTTC = 0;
  var items = "";
  var items2 = "";
  var items3 = "";
  $.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/orders',
    type: 'GET',
    dataType: "json",
    success: function(response) {
		var order = response.filter(function(n) {
          return n.orderId == orderId;
        })[0];
		var date = new Date(order.date);
		var day = date.getDate();
		if(day<10){
			day = "0" + day;
		}
		var month = date.getMonth()+1;
		if(month<10){
			month = "0" + month;
		}
		var year = date.getFullYear();
$.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/articles/' + orderId + '/'+user.id,
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var articles = response;
      $(articles).each(function(index) {
        items += '<div class="cart-overview-item">'
        +'<p class="text-header small">'+this.designation+' <span class="primary">x'+this.quantity+'</span></p>'
        +'<p class="price"><span></span>'+parseFloat(this.price * this.quantity).toFixed(2)+'</p>'
        +'<p class="category primary">'+this.packagingType+'</p>'
      +'</div>';
	  if(index >= 38 /*19*/) {
        items2 += '<tr>'
          +'<td class="desc">'+this.designation+' </td>'
          +'<td class="unit">'+parseFloat(this.price).toFixed(2)+'</td>'
        +'<td class="qty">'+this.quantity+'</td>'
        +'<td class="total">'+parseFloat(this.price * this.quantity).toFixed(2)+'</td>'
        +'<td class="tva">'+this.tva+'%</td>'
      +'</tr>';
	  } else {
        items3 += '<tr>'
          +'<td class="desc">'+this.designation+' </td>'
          +'<td class="unit">'+parseFloat(this.price).toFixed(2)+'</td>'
        +'<td class="qty">'+this.quantity+'</td>'
        +'<td class="total">'+parseFloat(this.price * this.quantity).toFixed(2)+'</td>'
        +'<td class="tva">'+this.tva+'%</td>'
      +'</tr>';
	  }
        totalHT += this.price * this.quantity;
		if (this.tva == 2.5){
			base2 += this.price * this.quantity;
		} else if (this.tva == 7.7){
			base7 += this.price * this.quantity;
		}
	});
	    tva2 = (base2 * 2.5) / 100;
		tva7 = (base7 * 7.7) / 100;
		totalTVA = tva2 + tva7;
		totalTTC = totalHT + tva2 + tva7;
	    totalFrancs = NumberToLetter(Math.floor(totalTTC));
	    totalCentimes = NumberToLetter(parseInt(totalTTC.toFixed(2).toString().split(".")[1]));
      var content = '<h4>Ref. '+year  +'-'+orderId + '</h4>' + '<hr class="line-separator">' + items + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(totalHT).toFixed(2) + '</p>' + '<p class="text-header total">Total HT</p>' + '</div>' + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(tva2).toFixed(2) + '</p>' + '<p class="text-header total">TVA 2.5% </p>' + '</div>' + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(tva7).toFixed(2) + '</p>' + '<p class="text-header total">TVA 7.7% </p>' + '</div>' + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(totalTTC).toFixed(2) + '</p>' + '<p class="text-header total">Total TTC</p>'  + '</div>'+ '<a class="button primary" onclick="invoicExport()">Exporter</a>'+ '<a class="button primary" onclick="orderLoad()">Charger au panier</a>';
      $('.jq-order-content').html(content);
	  var invoice = '<header class="clearfix">'
    +'<div id="project">'
      +'Le Palmier s&agrave;rl' 
	  + '<br>Route de Peney 51' 
	  + '<br>1214 Vernier' 
	  + '<br>TVA: CHE-485.765.573'
	  + '<br>contact@lepalmier-distribution.ch'
	  + '<br>+41 77 996 51 81'
   +'</div>'
    +'<div id="slogan" class="clearfix">'
      +'Osez l&apos;originalit&eacute;'
    +'</div>'
    +'<div class="clearfix"></div>'
    +'<div id="contact">'
    +'</div>'
    +'<div id="company">'
      + order.clientName
      +'<br>' +order.street
      +'<br>'+order.postalCode+' '+order.city
    +'</div>'
    +'<div class="clearfix"></div>'
    +'<div id="facture">'
      +'Facture proforma n&ordm; '+year  +'-'+orderId
    +'</div>'
    +'<div id="date">'
      +'Date: '+day+'.'+month+'.'+year 
    +'</div>'
  +'</header>'
  +'<main>'
    +'<table id="order">'
      +'<thead>'
        +'<tr>'
          +'<th class="desc">D&eacute;signation</th>'
          +'<th class="unit">Prix unit.</th>'
          +'<th class="qty">Qt&eacute;</th>'
          +'<th class="total">Montant</th>'
          +'<th class="tva">TVA</th>'
        +'</tr>'
      +'</thead>'
      +'<tbody>'
        + items3
    +'</tbody>'
    +'<table id="order">'
      +'<tbody>'
        + items2
    +'</tbody>'
  +'</table>'
  +'<div class="clearfix"></div>'
  +'<div id="tva">'
    +'<span>D&eacute;tail TVA:</span>'
    +'<table>'
      +'<thead>'
        +'<tr>'
          +'<th>Base</th>'
          +'<th>Taux</th>'
          +'<th>TVA</th>'
        +'</tr>'
      +'</thead>'
      +'<tbody>'
        +'<tr>'
          +'<td>'+parseFloat(base7).toFixed(2)+'</td>'
          +'<td>7.7%</td>'
          +'<td>'+parseFloat(tva7).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td>'+parseFloat(base2).toFixed(2)+'</td>'
          +'<td>2.5%</td>'
          +'<td>'+parseFloat(tva2).toFixed(2)+'</td>'
        +'</tr>'
      +'</tbody>'
    +'</table>'
  +'</div>'
  +'<div id="montant">'
    +'<table>'
      +'<tbody>'
        +'<tr>'
          +'<td class="first">Total net</td>'
          +'<td class="last">'+parseFloat(totalHT).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td class="first">TVA</td>'
          +'<td  class="last">'+parseFloat(totalTVA).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td class="first">Montant total TTC</td>'
          +'<td  class="last">'+parseFloat(totalTTC).toFixed(2)+'</td>'
        +'</tr>'
      +'</tbody>'
    +'</table>'
    +'<span>'+totalFrancs+' francs et '+totalCentimes+' centimes</span>'
  +'</div>'
  +'<div class="clearfix"></div>'
  +'<div id="notices">'
      +'Compte POSTFINANCE IBAN CH59 0900 0000 1451 3853 5<br>Avec nos meilleurs remerciements pour votre commande.'
    +'<br>contact@lepalmier-distribution.ch'
  +'</div>'
+'</main>';
	  $('#invoice').html(invoice);
    }
  })
	}
  })
  
}

function basketDisplay() {
  if (localStorage.basket) {
    var basket = JSON.parse(localStorage.getItem('basket'));
  } else {
    var basket = [];
  }
  console.log(basket);
  var total = 0;
  var items = "";
  $('.jq-basket-count').html(basket.length);
  $(basket).each(function(index) {
    items += '<li class="dropdown-item">' + '<a class="link-to"></a>' + '<figure class="product-preview-image tiny">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '<p class="text-header tiny">' + this.designation + '</p>' + '<p class="category tiny primary">x ' + this.quantity + '</p>' + '<p class="price tiny">' + parseFloat(this.price * this.quantity).toFixed(2) + '<span> CHF</span></p>' + '</li>';
    total += this.price * this.quantity;
  });
  items += '<li class="dropdown-item">' + '<p class="text-header tiny">Total</p>' + '<p class="price">' + parseFloat(total).toFixed(2) + '<span> CHF</span></p>' + '<a href="cart.html" class="button primary">Aller au panier</a>' + '</li>';
  $('.jq-basket-content').html(items);
}

function invoicExport() {
	if ($("#order:nth-child(2) tbody tr").length == 0) {
		$("#order:nth-child(2)").hide();
		$("#invoice").css("height", "29.7cm");
	} else {
		$("#order:nth-child(2)").show();
		$("#order:nth-child(2)").css("margin-top", "6cm");
		$("#invoice").css("height", "59.4cm");
	}
	window.print();
	//$('#invoice').printThis();
/*
	var pdf = new jsPDF('p', 'mm', 'a4');
  var options = {
       pagesplit: true
  };
  $('#invoice').show();
  console.log($("#order:nth-child(2) tbody tr").length);
if ($("#order:nth-child(2) tbody tr").length == 0) {
	   $("#order:nth-child(2)").hide();
	  $("#invoice").css("height", "22.2cm");

	} else {
			   $("#order:nth-child(2)").show();

		 $("#order:nth-child(2)").css("margin-top", "6cm");
		$("#invoice").css("height", "44.4cm");

	} 

pdf.addHTML($('#invoice').first(), options, function() {
        pdf.save("Facture.pdf");
		$('#invoice').hide();


    });
*/
}

function orderLoad() {
  var user = JSON.parse(localStorage.getItem('user'));
  var orderId = window.location.hash.substr(1);  
  $.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/basketLoading/' + orderId + '/' + user.id,
    type: 'POST',
    dataType: "json",
    contentType: "application/json; charset=utf-8",
    success: function(response) {
      localStorage.setItem('basket', JSON.stringify(response.basket));
      basketDisplay();
      window.location.href = 'cart.html';
    }
  })
}

function userDisplay() {
  var user = JSON.parse(localStorage.getItem('user'));
  $('.jq-username').html(user.username);
  $('.jq-company-name').html(user.companyName);
}

function logout() {
  localStorage.clear();
  window.location.href = 'login.html';
}

/* ------------------
	PHP - session
--------------------*/
/*
var user;
var basket;
  $.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/session/user',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(response.error) {  
		window.location.href = 'login.html';
	  } else {
		  user = response;
 userDisplay();

	  }
    }
  })
  $.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/session/basket',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(!response.error) {  
				  basket = response;

	  } else {
    basket = [];
  }
    basketDisplay();

    }
  })


$(document).ready(function() {

  articlesDisplay();
});

function articlesDisplay() {
var orderId = window.location.hash.substr(1);  
  var totalHT = 0;
  var tva2 = 0;
  var base2 = 0;
  var tva7 = 0;
  var base7 = 0;
  var totalTVA = 0;
  var totalTTC = 0;
  var items = "";
  var items2 = "";
  $.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/orders',
    type: 'GET',
    dataType: "json",
    success: function(response) {
		var order = response.filter(function(n) {
          return n.orderId == orderId;
        })[0];
		var date = new Date(order.date);
		var day = date.getDate();
		if(day<10){
			day = "0" + day;
		}
		var month = date.getMonth()+1;
		if(month<10){
			month = "0" + month;
		}
		var year = date.getFullYear();
$.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/articles/' + orderId,
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var articles = response;
      $(articles).each(function(index) {
        items += '<div class="cart-overview-item">'
        +'<p class="text-header small">'+this.designation+' <span class="primary">x'+this.quantity+'</span></p>'
        +'<p class="price"><span></span>'+parseFloat(this.price * this.quantity).toFixed(2)+'</p>'
        +'<p class="category primary">'+this.packagingType+'</p>'
      +'</div>';
        items2 += '<tr>'
          +'<td class="desc">'+this.designation+' </td>'
          +'<td class="unit">'+parseFloat(this.price).toFixed(2)+'</td>'
        +'<td class="qty">'+this.quantity+'</td>'
        +'<td class="total">'+parseFloat(this.price * this.quantity).toFixed(2)+'</td>'
        +'<td class="tva">'+this.tva+'%</td>'
      +'</tr>';
        totalHT += this.price * this.quantity;
		if (this.tva == 2.5){
			base2 += this.price * this.quantity;
		} else if (this.tva == 7.7){
			base7 += this.price * this.quantity;
		}
	});
	    tva2 = (base2 * 2.5) / 100;
		tva7 = (base7 * 7.7) / 100;
		totalTVA = tva2 + tva7;
		totalTTC = totalHT + tva2 + tva7;
	    totalFrancs = NumberToLetter(Math.floor(totalTTC));
	    totalCentimes = NumberToLetter(parseInt(totalTTC.toFixed(2).toString().split(".")[1]));
      var content = '<h4>Ref. '+year  +'-'+orderId + '</h4>' + '<hr class="line-separator">' + items + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(totalHT).toFixed(2) + '</p>' + '<p class="text-header total">Total HT</p>' + '</div>' + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(tva2).toFixed(2) + '</p>' + '<p class="text-header total">TVA 2.5% </p>' + '</div>' + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(tva7).toFixed(2) + '</p>' + '<p class="text-header total">TVA 7.7% </p>' + '</div>' + '<div class="cart-total small">' + '<p class="price"><span></span>' + parseFloat(totalTTC).toFixed(2) + '</p>' + '<p class="text-header total">Total TTC</p>'  + '</div>'+ '<a class="button primary" onclick="invoicExport()">Exporter</a>';
      $('.jq-order-content').html(content);
	  var invoice = '<header class="clearfix">'
    +'<div id="project">'
      +'Rivers S&agrave;RL'
      +'<br>Case postale 5825'
      +'<br>1204 Gen&egrave;ve'
	  +'<br>TVA: CHE-459.282.487'
   +'</div>'
    +'<div id="slogan" class="clearfix">'
      +'Vos boissons &agrave; votre porte'
    +'</div>'
    +'<div class="clearfix"></div>'
    +'<div id="contact">'
      +'T&eacute;l: 078 696 1999 Jamila'
      +'<br>T&eacute;l: 078 638 2133 Samir'
      +'<br>Email: <a href="mailto:j.moussaoui@riversjam.ch">j.moussaoui@riversjam.ch</a>'
    +'</div>'
    +'<div id="company">'
      + order.clientName
      +'<br><br>' +order.street
      +'<br>'+order.postalCode+' '+order.city
    +'</div>'
    +'<div class="clearfix"></div>'
    +'<div id="facture">'
      +'Facture pro forma n&ordm; '+year  +'-'+orderId
    +'</div>'
    +'<div id="date">'
      +'Date: '+day+'.'+month+'.'+year 
    +'</div>'
  +'</header>'
  +'<main>'
    +'<table id="order">'
      +'<thead>'
        +'<tr>'
          +'<th class="desc">D&eacute;signation</th>'
          +'<th class="unit">Prix unit.</th>'
          +'<th class="qty">Qt&eacute;</th>'
          +'<th class="total">Montant</th>'
          +'<th class="tva">TVA</th>'
        +'</tr>'
      +'</thead>'
      +'<tbody>'
        + items2
    +'</tbody>'
  +'</table>'
  +'<div class="clearfix"></div>'
  +'<div id="tva">'
    +'<span>D&eacute;tail TVA:</span>'
    +'<table>'
      +'<thead>'
        +'<tr>'
          +'<th>Base</th>'
          +'<th>Taux</th>'
          +'<th>TVA</th>'
        +'</tr>'
      +'</thead>'
      +'<tbody>'
        +'<tr>'
          +'<td>'+parseFloat(base7).toFixed(2)+'</td>'
          +'<td>7.7%</td>'
          +'<td>'+parseFloat(tva7).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td>'+parseFloat(base2).toFixed(2)+'</td>'
          +'<td>2.5%</td>'
          +'<td>'+parseFloat(tva2).toFixed(2)+'</td>'
        +'</tr>'
      +'</tbody>'
    +'</table>'
  +'</div>'
  +'<div id="montant">'
    +'<table>'
      +'<tbody>'
        +'<tr>'
          +'<td class="first">Total net</td>'
          +'<td class="last">'+parseFloat(totalHT).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td class="first">TVA</td>'
          +'<td  class="last">'+parseFloat(totalTVA).toFixed(2)+'</td>'
        +'</tr>'
        +'<tr>'
          +'<td class="first">Montant total TTC</td>'
          +'<td  class="last">'+parseFloat(totalTTC).toFixed(2)+'</td>'
        +'</tr>'
      +'</tbody>'
    +'</table>'
    +'<span>'+totalFrancs+' francs et '+totalCentimes+' centimes</span>'
  +'</div>'
  +'<div class="clearfix"></div>'
  +'<div id="notices">'
      +'Avec nos meilleurs remerciements pour votre commande.'
    +'<br>Jamila 078 696 19 99 et Samir 078 638 21 33'
  +'</div>'
+'</main>';
	  $('#invoice').html(invoice);
    }
  })
	}
  })
  
}



function invoicExport() {
  	var pdf = new jsPDF('p', 'mm', 'a4');
$('#invoice').show();

pdf.addHTML($('#invoice').first(), function() {
        pdf.save("Facture.pdf");
		$('#invoice').hide();

    });
}

function basketDisplay() {
  var total = 0;
  var items = "";
  $('.jq-basket-count').html(basket.length);
  $(basket).each(function(index) {
    items += '<li class="dropdown-item">' + '<a class="link-to"></a>' + '<figure class="product-preview-image tiny">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '<p class="text-header tiny">' + this.designation + '</p>' + '<p class="category tiny primary">x ' + this.quantity + '</p>' + '<p class="price tiny"><span>$</span>' + parseFloat(this.price * this.quantity).toFixed(2) + '</p>' + '</li>';
    total += this.price * this.quantity;
  });
  items += '<li class="dropdown-item">' + '<p class="text-header tiny">Total</p>' + '<p class="price"><span>$</span>' + parseFloat(total).toFixed(2) + '</p>' + '<a href="cart.html" class="button primary">Aller au panier</a>' + '</li>';
  $('.jq-basket-content').html(items);
}

function userDisplay() {
  $('.jq-username').html(user.username);
  $('.jq-company-name').html(user.companyName);
}

function logout() {
  $.ajax({
    url: 'https://lepalmier-distribution.ch/myprovider/api/session/destroy',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(response.notice) {  
		window.location.href = 'login.html';
	  }
    }
  })
}
*/
