var table = $('#recordsTable').DataTable({
  "order": [
    [0, "desc"]
  ],
  "columns": [{
      "width": "20%"
    },
    {
      "width": "45%"
    },
    {
      "width": "15%"
    },
    {
      "width": "20%"
    }
  ]
});
$(document).ready(function() {
  $.fn.isValid = function() {
    return this[0].checkValidity();
  }
  recordsDisplay();
});

function recordsDisplay() {
  $.ajax({
    url: './api/records',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var records = response;
      $(records).each(function(index) {
        if (records[index].type == 'in') {
          type = '<span class="text-info"><i class="entypo-login"></i> Entrée</span>';
        } else {
          type = '<span class="text-warning"><i class="entypo-logout"></i> Sortie</span>';
        }
        table.row.add([
          records[index].recordDate,
          records[index].productDesignation,
          records[index].quantity,
          type
        ]).draw();
      });
    }
  })
}