var table = $('#productsTable').DataTable({
  "columns": [{
      "width": "30%"
    },
    {
      "width": "10%"
    },
    {
      "width": "10%"
    },
    {
      "width": "15%"
    },
    {
      "width": "15%"
    },
    {
      "width": "20%"
    }
  ]
});
$(document).ready(function() {
  $.fn.isValid = function() {
    return this[0].checkValidity();
  }
  productsDisplay();
});

function productsDisplay() {
  $.ajax({
    url: './api/products',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var products = response;
      $(products).each(function(index) {
        action = '<a onclick="modalEdit(' + products[index].productId + ',\'' + products[index].designation + '\', event);" class="btn btn-info btn-sm" data-toggle="modal" data-target="#sample-modal-edit">' +
          '<i class="entypo-login"></i></a>' +
          '<span>&nbsp;</span>' +
          '<a onclick="modalCost(' + products[index].productId + ', ' + products[index].cost + ', event);" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#sample-modal-cost" id="btnCost">' +
          '<i class="entypo-ticket"></i></a>' +
          '<span>&nbsp;</span>' +
          '<a onclick="modalDelete(' + products[index].productId + ', event);" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#sample-modal-delete">' +
          '<i class="entypo-trash"></i></a>';
        table.row.add([
          products[index].designation,
          products[index].packaging,
          products[index].cost,
          products[index].quantity,
          products[index].orderQuantity,
          action
        ]).draw();
      });
    }
  })
}

function productAdd() {
  if ($("#product-add-form").isValid()) {
    $('#sample-modal-add #btn-add').attr('data-dismiss', 'modal');
    designation = $("#product-add-form #designation").val();
    packaging = $("#product-add-form #packaging").val();
    quantity = $("#product-add-form #quantity").val();
    cost = $("#product-add-form #cost").val();
    formData = {
      designation: designation,
      packaging: packaging,
      quantity: quantity,
	  cost: cost
    };
    $.ajax({
      url: './api/product/add',
      type: 'POST',
      data: JSON.stringify(formData),
      contentType: "application/json",
      success: function(response) {
        response = JSON.parse(response);
        if (response.notice) {
          action = '<a onclick="modalEdit(' + response.notice.id + ',\'' + designation + '\', event);" class="btn btn-info btn-sm" data-toggle="modal" data-target="#sample-modal-edit">' +
            '<i class="entypo-login"></i></a>' +
          '<span>&nbsp;</span>' +
          '<a onclick="modalCost(' + response.notice.id + ', ' + cost + ', event);" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#sample-modal-cost" id="btnCost">' +
          '<i class="entypo-ticket"></i></a>' +
            '<span>&nbsp;</span>' +
            '<a onclick="modalDelete(' + response.notice.id + ', event);" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#sample-modal-delete">' +
            '<i class="entypo-trash"></i></a>';
          table.row.add([
            designation,
            packaging,
			cost,
            quantity,
            0,
            action
          ]).draw();
          $("#alertMessage").html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success! </strong> ' + response.notice.text + '.</div>');
        } else {
          $("#alertMessage").html('<div class="alert alert-danger alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Error! </strong> ' + response.error.text + '.</div>');
        }
        $("#product-add-form")[0].reset();
      }
    })
  }
}

function modalEdit(productId, designation, event) {
  var index = $(event.target).closest('tr').index();
  $('#sample-modal-edit #designation').html(designation);
  $('#sample-modal-edit #btn-edit').attr('onClick', 'productEdit(' + productId + ', ' + index + ')');
}

function productEdit(productId, index) {
  if ($("#product-edit-form").isValid()) {
    $('#sample-modal-edit #btn-edit').attr('data-dismiss', 'modal');
    quantity = $("#product-edit-form #quantity").val();
    formData = {
      productId: productId,
      quantity: quantity,
      action: "credit"
    };
    $.ajax({
      url: './api/product/update',
      type: 'PUT',
      data: JSON.stringify(formData),
      contentType: "application/json",
      success: function(response) {
        response = JSON.parse(response);
        if (response.notice) {
          index++;
          var test = $('tr:eq(' + index + ')').find("td").eq(3);
          table.cell(test).data(response.notice.quantity).draw();
          $("#alertMessage").html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success! </strong> ' + response.notice.text + '.</div>');
        } else {
          $("#alertMessage").html('<div class="alert alert-danger alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Error! </strong> ' + response.error.text + '.</div>');
        }
        $("#product-edit-form")[0].reset();
      }
    })
  }
}

function modalCost(productId, cost, event) {
  var index = $(event.target).closest('tr').index();
  $('#sample-modal-cost #productId').html(productId);
  $('#sample-modal-cost #cost').val(cost);
  $('#sample-modal-cost #btn-cost').attr('onClick', 'productEditCost(' + productId + ', ' + index + ')');
}

function productEditCost(productId, index) {
  if ($("#product-edit-cost-form").isValid()) {
    $('#sample-modal-cost #btn-cost').attr('data-dismiss', 'modal');
    cost = $("#product-edit-cost-form #cost").val();
    formData = {
      productId: productId,
      cost: cost
    };
    $.ajax({
      url: './api/product/updateCost',
      type: 'PUT',
      data: JSON.stringify(formData),
      contentType: "application/json",
      success: function(response) {
        response = JSON.parse(response);
        if (response.notice) {
          index++;
          var test = $('tr:eq(' + index + ')').find("td").eq(2);
          table.cell(test).data(cost).draw();
		  $('tr:eq(' + index + ')').find("#btnCost").attr('onClick', 'modalCost(' + productId + ', ' + cost + ', event)');
          $("#alertMessage").html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success! </strong> ' + response.notice.text + '.</div>');
        } else {
          $("#alertMessage").html('<div class="alert alert-danger alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Error! </strong> ' + response.error.text + '.</div>');
        }
        $("#product-edit-cost-form")[0].reset();
      }
    })
  }
}

function modalDelete(productId, event) {
  var index = $(event.target).closest('tr').index();
  $('#sample-modal-delete #productId').html(productId);
  $('#sample-modal-delete #btn-delete').attr('onClick', 'productDelete(' + productId + ', ' + index + ')');
}

function productDelete(productId, index) {
  $.ajax({
    url: './api/product/delete/' + productId,
    type: 'DELETE',
    contentType: "application/json",
    success: function(response) {
      response = JSON.parse(response);
      if (response.notice) {
        table
          .row('tr:visible:eq(' + index + ')')
          .remove()
          .draw();
        $("#alertMessage").html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success! </strong> ' + response.notice.text + '.</div>');
      } else {
        $("#alertMessage").html('<div class="alert alert-danger alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Error! </strong> ' + response.error.text + '.</div>');
      }
    }
  })
}