var table = $('#ordersTable').DataTable({
  "order": [
    [0, "desc"]
  ],
  "columns": [{
      "width": "20%"
    },
    {
      "width": "40%"
    },
    {
      "width": "20%"
    },
    {
      "width": "20%"
    }
  ]
});
$(document).ready(function() {
  $.fn.isValid = function() {
    return this[0].checkValidity();
  }
  ordersDisplay();
});

function ordersDisplay() {
  $.ajax({
    url: './api/orders',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var orders = response;
      $(orders).each(function(index) {
        if (orders[index].state == "0") {
          state = '<span class="text-success"><i class="entypo-progress-1"></i> En cours</span>';          
        } else {
          state = '<span class="text-danger"><i class="entypo-progress-3"></i> Terminé</span>';

        }
        action = '<a href="order.html#' + orders[index].orderId + '" class="btn btn-blue btn-sm">' +
          '<i class="entypo-eye"></i></a>';
        table.row.add([
          orders[index].orderDate,
          orders[index].clientName,
          state,
          action,
        ]).draw();
      });
    }
  })
}