var table = $('#goodsTable').DataTable({
  "order": [
    [2, "asc"]
  ],
  "paging": false
});
$(document).ready(function() {
  $.fn.isValid = function() {
    return this[0].checkValidity();
  }
  goodsDisplay();
});

function goodsDisplay() {
  orderId = window.location.hash.substr(1);
  $.ajax({
    url: './api/goods/' + orderId,
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var order = response;
      var goods = order.goods;
      $("#orderId").html(orderId);
      $("#clientName").html(order.clientName);
      $(goods).each(function(index) {
        if (goods[index].state == "0") {
          state = '<span class="text-success"><i class="entypo-progress-1"></i> En attente</span>';
          action = '<a onclick="modalEdit(' + goods[index].goodId + ', \'' + goods[index].productDesignation +  '\', ' + goods[index].orderQuantity + ',\'' + order.clientName + '\', event);" class="btn btn-warning btn-sm" data-toggle="modal" data-target="#sample-modal-edit">' +
            '<i class="entypo-logout"></i></a>';
        } else {
          state = '<span class="text-danger"><i class="entypo-progress-3"></i> Livré</span>';
          action = '<a href="javascript:void(0);" class="btn btn-warning btn-sm disabled">' +
            '<i class="entypo-logout"></i></a>';
        }
        table.row.add([
          goods[index].productDesignation,
          goods[index].orderQuantity,
          goods[index].deliveryQuantity,
          goods[index].deliveryDate,
          state,
          action,
        ]).draw();
      });
    }
  })
}

function modalEdit(goodId, designation, quantity, clientName, event) {
  $('#sample-modal-edit #productDesignation').html(designation);
  $('#sample-modal-edit #quantity').val(quantity);
  var index = $(event.target).closest('tr').index();
  $('#sample-modal-edit #btn-edit').attr('onClick', 'goodEdit(' + goodId + ', \'' + clientName + '\', ' + index + ')');
}

function goodEdit(goodId, clientName, index) {
  if ($("#product-delivery-form").isValid()) {
  $('#sample-modal-edit #btn-edit').attr('data-dismiss', 'modal');
  deliveryQuantity = $('#product-delivery-form #quantity').val()
  formData = {
    goodId: goodId,
    action: "debit",
    deliveryQuantity: deliveryQuantity,
    clientName: clientName
  };
  $.ajax({
    url: './api/product/update',
    type: 'PUT',
    data: JSON.stringify(formData),
    contentType: "application/json",
    success: function(response) {
      response = JSON.parse(response);
      if (response.notice) {
        index++;
        var test3 = $('tr:eq(' + index + ')').find("td").eq(2);
        var test4 = $('tr:eq(' + index + ')').find("td").eq(3);
        var test = $('tr:eq(' + index + ')').find("td").eq(4);
        var test2 = $('tr:eq(' + index + ')').find("td").eq(5);
        table.cell(test4).data(response.notice.deliveryDate).draw();
        table.cell(test3).data(deliveryQuantity).draw();
        table.cell(test).data('<span class="text-danger"><i class="entypo-progress-3"></i> Livré</span>').draw();
        table.cell(test2).data('<a href="javascript:void(0);" class="btn btn-warning btn-sm disabled">' +
            '<i class="entypo-logout"></i></a>').draw();
        $("#alertMessage").html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success! </strong> ' + response.notice.text + '.</div>');
      } else {
        $("#alertMessage").html('<div class="alert alert-danger alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Error! </strong> ' + response.error.text + '.</div>');
      }
      $("#product-delivery-form")[0].reset();
    }
  })
}
}