var table = $('#productsTable').DataTable({
  "columns": [{
      width: "80%"
    },
    {
      width: "20%",
      className: "text-danger"
    }
  ],
  "info": false,
  "searching": false,
  "paging": false
});

$(document).ready(function() {
  statsDisplay();
});

function statsDisplay() {
  $.ajax({
    url: './api/dashboard',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var stats = response;
      $("#numberOfProducts").html(stats.numberOfProducts);
      $("#numberOfClients").html(stats.numberOfClients);
      $("#numberOfOrders").html(stats.numberOfOrders);
      products = stats.products.filter(function(product) {
        return(product.replenishment < 0);
      });;
      $(products).each(function(index) {
        table.row.add([
          products[index].productDesignation,
          products[index].replenishment
        ]).draw();
      });
    }
  })
}