var table = $('#recordsTable').DataTable({
  "order": [
    [0, "desc"]
  ],
  "columns": [{
      "width": "20%"
    },
    {
      "width": "30%"
    },
    {
      "width": "15%"
    },
    {
      "width": "15%"
    },
    {
      "width": "20%"
    }
  ]
});
var table2 = $('#recordsTableGlobal').DataTable({
  "order": [
    [0, "asc"]
  ],
  "columns": [{
      "width": "30%"
    },
    {
      "width": "20%"
    },
    {
      "width": "15%"
    },
    {
      "width": "20%"
    },
    {
      "width": "15%"
    }
  ]
});
$(document).ready(function() {
  $.fn.isValid = function() {
    return this[0].checkValidity();
  }
  $("#recordsTable_wrapper").hide();	
  $("#recordsTableGlobal_wrapper").hide();
   productsDisplay();
});

function productsDisplay() {
  $.ajax({
    url: './api/products',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var products = response;
      $(products).each(function(index) {
        $("#search-form #product").append('<option value="'+products[index].designation+'">'+products[index].designation+'</option>');
      });
    }
  })
}

function recordsDisplay() {
  if($("#search-form").isValid()) {
	  startDate = $("#startDate").val();
	  endDate = $("#endDate").val();
	  product = $("#product").val();
	  mode = $("#mode").val();
	formData = {
      startDate: startDate,
      endDate: endDate,
      mode: mode,
	  product: product
    };
	  $.ajax({
		url: './api/exports',
		type: 'POST',
		data: JSON.stringify(formData),
		contentType: "application/json",
		success: function(response) {
		  var records = JSON.parse(response);
		  if(product!=0){
			if(mode==2){
				table.clear().draw();
				var text="";
				$(records).each(function(index) {
					if (records[index].type == 'in') {
					  type = '<span class="text-info"><i class="entypo-login"></i> Entrée</span>';
					} else {
					  type = '<span class="text-warning"><i class="entypo-logout"></i> Sortie</span>';
					}
					table.row.add([
					  records[index].recordDate,
					  records[index].productDesignation,
					  records[index].quantity,
					  records[index].cost,
					  type
					]).draw();
					text += records[index].recordDate +";"+ records[index].productDesignation +";"+ records[index].quantity +";"+ records[index].cost +";"+ records[index].type +'\n';
				  });
				  $("#recordsTable_wrapper").show();	
				  $("#recordsTableGlobal_wrapper").hide();
				   if (confirm("Voulez-vous exporter le fichier csv ?")) { 
				  		 var element = document.createElement('a');
  						element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
  						element.setAttribute('download', startDate+"_"+endDate+"_"+product+"_Detail.csv");
						element.click();
				   }
			}
			if(mode==1){
				table2.clear().draw();
				var text="";
					table2.row.add([
					  records.productDesignation,
					  records.in,
					  records.costIn,
					  records.out,
					  records.costOut
					]).draw();
					text += records.productDesignation  +";"+ records.in +";"+ records.costIn +";"+ records.out +";"+ records.costOut +'\n';
				  $("#recordsTable_wrapper").hide();	
				  $("#recordsTableGlobal_wrapper").show();
				   if (confirm("Voulez-vous exporter le fichier csv ?")) { 
				  		 var element = document.createElement('a');
  						element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
  						element.setAttribute('download', startDate+"_"+endDate+"_"+product+"_Global.csv");
						element.click();
				   }
			}
		  } else {
			if(mode==1){
				table2.clear().draw();
				var text="";
				$(records).each(function(index) {
					table2.row.add([
					  records[index].productDesignation,
					  records[index].in,
					  records[index].costIn,
					  records[index].out,
					  records[index].costOut
					]).draw();
					text += records[index].productDesignation  +";"+ records[index].in +";"+ records[index].costIn +";"+ records[index].out +";"+ records[index].costOut +'\n';
				  });
				  $("#recordsTable_wrapper").hide();	
				  $("#recordsTableGlobal_wrapper").show();
				   if (confirm("Voulez-vous exporter le fichier csv ?")) { 
				  		 var element = document.createElement('a');
  						element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
  						element.setAttribute('download', startDate+"_"+endDate+"_"+"ALL_Global.csv");
						element.click();
				   }
				
			}
			if(mode==2){
				table.clear().draw();
				var text="";
				$(records).each(function(index) {
					if (records[index].type == 'in') {
					  type = '<span class="text-info"><i class="entypo-login"></i> Entrée</span>';
					} else {
					  type = '<span class="text-warning"><i class="entypo-logout"></i> Sortie</span>';
					}
					table.row.add([
					  records[index].recordDate,
					  records[index].productDesignation,
					  records[index].quantity,
					  records[index].cost,
					  type
					]).draw();
					text += records[index].recordDate +";"+ records[index].productDesignation +";"+ records[index].quantity +";"+ records[index].cost +";"+ records[index].type +'\n';
				  });
				  $("#recordsTable_wrapper").show();	
				  $("#recordsTableGlobal_wrapper").hide();
				   if (confirm("Voulez-vous exporter le fichier csv ?")) { 
				  		 var element = document.createElement('a');
  						element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
  						element.setAttribute('download', startDate+"_"+endDate+"_"+"ALL_Detail.csv");
						element.click();
				   }
			}
		  }
		}
	  })	 
  }
}