var table = $('#clientsTable').DataTable({
  "columns": [{
      "width": "80%"
    },
    {
      "width": "20%"
    }
  ]
});
$(document).ready(function() {
  $.fn.isValid = function() {
    return this[0].checkValidity();
  }
  clientsDisplay();
});

function clientsDisplay() {
  $.ajax({
    url: './api/clients',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      var clients = response;
      $(clients).each(function(index) {
        action = '<a onclick="modalDelete(' + clients[index].clientId + ', event);" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#sample-modal-delete">' +
          '<i class="entypo-trash"></i></a>';
        table.row.add([
          clients[index].name,
          action
        ]).draw();
      });
    }
  })
}

function clientAdd() {
  if ($("#client-add-form").isValid()) {
    $('#sample-modal-add #btn-add').attr('data-dismiss', 'modal');
    name = $("#client-add-form #name").val();
    formData = {
      name: name
    };
    $.ajax({
      url: './api/client/add',
      type: 'POST',
      data: JSON.stringify(formData),
      contentType: "application/json",
      success: function(response) {
        response = JSON.parse(response);
        if (response.notice) {
          action = '<a onclick="modalDelete(' + response.notice.id + ', event);" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#sample-modal-delete">' +
            '<i class="entypo-trash"></i></a>';
          table.row.add([
            name,
            action
          ]).draw();
          $("#alertMessage").html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success! </strong> ' + response.notice.text + '.</div>');
        } else {
          $("#alertMessage").html('<div class="alert alert-danger alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Error! </strong> ' + response.error.text + '.</div>');
        }
        $("#client-add-form")[0].reset();
      }
    })
  }
}

function modalDelete(clientId, event) {
  $('#sample-modal-delete #clientId').html(clientId);
  var index = $(event.target).closest('tr').index();
  $('#sample-modal-delete #btn-delete').attr('onClick', 'clientDelete(' + clientId + ', ' + index + ')');
}

function clientDelete(clientId, index) {
  $.ajax({
    url: './api/client/delete/' + clientId,
    type: 'DELETE',
    contentType: "application/json",
    success: function(response) {
      response = JSON.parse(response);
      if (response.notice) {
        table
          .row('tr:visible:eq(' + index + ')')
          .remove()
          .draw();
        $("#alertMessage").html('<div class="alert alert-success alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Success! </strong> ' + response.notice.text + '.</div>');
      } else {
        $("#alertMessage").html('<div class="alert alert-danger alert-dismissible"><a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a><strong>Error! </strong> ' + response.error.text + '.</div>');
      }
    }
  })
}