<?php
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;

$app = new \Slim\App;

$app->options('/{routes:.+}', function($request, $response, $args)
{
    return $response;
});

$app->add(function($req, $res, $next)
{
    $response = $next($req, $res);
    return $response->withHeader('Access-Control-Allow-Origin', '*')->withHeader('Access-Control-Allow-Headers', 'X-Requested-With, Content-Type, Accept, Origin, Authorization')->withHeader('Access-Control-Allow-Methods', 'GET, POST, PUT, DELETE, OPTIONS');
});

/* ==============================================
API: v1.0
    - Client
	- Record
    - Product
    - Order
    - Dashboard
    - Stock
    - Raw
	- Export

================================================ */

/* ------------------
    Client
--------------------*/
// Get All Clients
$app->get('/clients', function(Request $request, Response $response)
{
    $sql = "SELECT * FROM clients";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt    = $db->query($sql);
        $clients = $stmt->fetchAll(PDO::FETCH_OBJ);
        $db      = null;
        echo json_encode($clients);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Add Client
$app->post('/client/add', function(Request $request, Response $response)
{
    $name = strtoupper($request->getParam('name'));
    $sql         = "INSERT INTO clients (name) VALUES (:name)";
    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':name', $name);
        $stmt->execute();
        $id = $db->lastInsertId();
        $db = null;
        echo '{"notice": {"text": "Client Ajouté", "id": ' . $id . '}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Delete Client
$app->delete('/client/delete/{clientId}', function(Request $request, Response $response)
{
    $clientId  = $request->getAttribute('clientId');
    $sql = "DELETE FROM clients WHERE clientId = $clientId";
    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $db = null;
        echo '{"notice": {"text": "Client Supprimé"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

/* ------------------
    Record
--------------------*/
// Get All Records
$app->get('/records', function(Request $request, Response $response)
{
    $sql = "SELECT * FROM records ORDER BY recordId DESC";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt    = $db->query($sql);
        $records = $stmt->fetchAll(PDO::FETCH_OBJ);
        $db      = null;
        echo json_encode($records);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

/* ------------------
    Product
--------------------*/
// Get All Products
$app->get('/products', function(Request $request, Response $response)
{
    $sql = "SELECT * FROM products";
    $sql2 = "SELECT SUM(orderQuantity) AS orderQuantity FROM goods WHERE productDesignation = :productDesignation AND state = 0";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt    = $db->query($sql);
        $products = $stmt->fetchAll(PDO::FETCH_OBJ);
        $index = 0;
        foreach($products as $product) {
            $stmt = $db->prepare($sql2);
            $stmt->bindParam(':productDesignation', $product->designation);
            $stmt->execute();
            $good = $stmt->fetch(PDO::FETCH_OBJ);
            $products[$index]->orderQuantity =  ($good->orderQuantity != null) ? $good->orderQuantity : "0";
            $index++;
        }
        $db      = null;
        echo json_encode($products);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Add Product
$app->post('/product/add', function(Request $request, Response $response)
{
    $designation = $request->getParam('designation');
    $packaging = $request->getParam('packaging');
    $quantity = $request->getParam('quantity');
	$cost = $request->getParam('cost');
    $sql = "INSERT INTO products (designation, packaging, quantity, cost) VALUES (:designation, :packaging, :quantity, :cost)";
    $sql2 = "INSERT INTO records (productDesignation, type, quantity, recordDate) VALUES (:productDesignation, 'in', :quantity, NOW())";
    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':designation', $designation);
        $stmt->bindParam(':packaging', $packaging);
        $stmt->bindParam(':quantity', $quantity);
        $stmt->bindParam(':cost', $cost);
        $stmt->execute();
        $id = $db->lastInsertId();
        if($quantity != 0) {
            $stmt = $db->prepare($sql2);
            $stmt->bindParam(':productDesignation', $designation);
            $stmt->bindParam(':quantity', $quantity);
            $stmt->execute();
        }
        $db = null;
        echo '{"notice": {"text": "Produit Ajouté", "id": "' . $id . '"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Update Product
$app->put('/product/update', function(Request $request, Response $response)
{
    $action = $request->getParam('action');
    $sql = "SELECT * FROM products WHERE productId = :productId";
    $sql2 = "INSERT INTO records (productDesignation, type, quantity, recordDate) VALUES (:productDesignation, :type, :quantity, NOW())";
    $sql3 = "UPDATE products SET quantity = :quantity WHERE  productId = :productId";
    $sql4 = "UPDATE goods SET state = 1, deliveryQuantity = :deliveryQuantity, deliveryDate = CURDATE() WHERE  goodId = :goodId";
    $sql5 = "SELECT * FROM goods WHERE goodId = :goodId";
    $sql6 = "SELECT * FROM products WHERE designation = :designation";

    $sql10 = "SELECT stockQuantity FROM stock_balexert WHERE product = :product";
    $sql11 = "UPDATE stock_balexert SET stockQuantity = :stockQuantity WHERE product = :product";

    $sql12 = "SELECT stockQuantity FROM stock_fribourg WHERE product = :product";
    $sql13 = "UPDATE stock_fribourg SET stockQuantity = :stockQuantity WHERE product = :product";

    $sql14 = "SELECT stockQuantity FROM stock_lausanne WHERE product = :product";
    $sql15 = "UPDATE stock_lausanne SET stockQuantity = :stockQuantity WHERE product = :product";

    $sql16 = "SELECT stockQuantity FROM stock_paquis WHERE product = :product";
    $sql17 = "UPDATE stock_paquis SET stockQuantity = :stockQuantity WHERE product = :product";

    $sql18 = "SELECT stockQuantity FROM stock_plainpalais WHERE product = :product";
    $sql19 = "UPDATE stock_plainpalais SET stockQuantity = :stockQuantity WHERE product = :product";

    $sql20 = "SELECT stockQuantity FROM stock_renens WHERE product = :product";
    $sql21 = "UPDATE stock_renens SET stockQuantity = :stockQuantity WHERE product = :product";

    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        //Entrée
        if($action == 'credit') {
            $productId = $request->getParam('productId');
            $quantity = $request->getParam('quantity');
            $stmt = $db->prepare($sql);
            $stmt->bindParam(':productId', $productId);
            $stmt->execute();
            $product = $stmt->fetch(PDO::FETCH_OBJ);
            $newQuantity = $product->quantity + $quantity;
            $type = 'in';
            $stmt = $db->prepare($sql2);
            $stmt->bindParam(':productDesignation', $product->designation);
            $stmt->bindParam(':type', $type);
            $stmt->bindParam(':quantity', $quantity);
            $stmt->execute();
            $stmt = $db->prepare($sql3);
            $stmt->bindParam(':quantity', $newQuantity);
            $stmt->bindParam(':productId', $productId);
            $stmt->execute();
            echo '{"notice": {"text": "Quantité mise à jour", "quantity":"' . $newQuantity . '"}}';
        } 
        //Sortie
        else  {
            $clientName = $request->getParam('clientName');
            $goodId = $request->getParam('goodId');
            $deliveryQuantity = $request->getParam('deliveryQuantity');
            $stmt = $db->prepare($sql5);
            $stmt->bindParam(':goodId', $goodId);
            $stmt->execute();
            $good = $stmt->fetch(PDO::FETCH_OBJ);
            $stmt = $db->prepare($sql6);
            $stmt->bindParam(':designation', $good->productDesignation);
            $stmt->execute();
            $product = $stmt->fetch(PDO::FETCH_OBJ);
            if($product->quantity >= $deliveryQuantity)  {
                $newQuantity = $product->quantity - $deliveryQuantity;
                $type = 'out';
                $stmt = $db->prepare($sql2);
                $stmt->bindParam(':productDesignation', $product->designation);
                $stmt->bindParam(':type', $type);
                $stmt->bindParam(':quantity', $deliveryQuantity);
                $stmt->execute(); 
                $stmt = $db->prepare($sql3);
                $stmt->bindParam(':quantity', $newQuantity);
                $stmt->bindParam(':productId', $product->productId);
                $stmt->execute();
                $stmt = $db->prepare($sql4);
                $stmt->bindParam(':goodId', $goodId);
                $stmt->bindParam(':deliveryQuantity', $deliveryQuantity);
                $stmt->execute();
                switch ($clientName) {
                    case 'BALEXERT':
                        $stmt = $db->prepare($sql10);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->execute();
                        $item = $stmt->fetch(PDO::FETCH_OBJ);
                        $stockQuantity = $item->stockQuantity + $deliveryQuantity;
                        $stmt = $db->prepare($sql11);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->bindParam(':stockQuantity', $stockQuantity);
                        $stmt->execute();
                        break;
                    case 'FRIBOURG':
                        $stmt = $db->prepare($sql12);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->execute();
                        $item = $stmt->fetch(PDO::FETCH_OBJ);
                        $stockQuantity = $item->stockQuantity + $deliveryQuantity;
                        $stmt = $db->prepare($sql13);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->bindParam(':stockQuantity', $stockQuantity);
                        $stmt->execute();
                        break;
                    case 'LAUSANNE':
                        $stmt = $db->prepare($sql14);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->execute();
                        $item = $stmt->fetch(PDO::FETCH_OBJ);
                        $stockQuantity = $item->stockQuantity + $deliveryQuantity;
                        $stmt = $db->prepare($sql15);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->bindParam(':stockQuantity', $stockQuantity);
                        $stmt->execute();
                        break;
                    case 'PAQUIS':
                        $stmt = $db->prepare($sql16);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->execute();
                        $item = $stmt->fetch(PDO::FETCH_OBJ);
                        $stockQuantity = $item->stockQuantity + $deliveryQuantity;
                        $stmt = $db->prepare($sql17);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->bindParam(':stockQuantity', $stockQuantity);
                        $stmt->execute();
                        break;
                    case 'PLAINPALAIS':
                        $stmt = $db->prepare($sql18);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->execute();
                        $item = $stmt->fetch(PDO::FETCH_OBJ);
                        $stockQuantity = $item->stockQuantity + $deliveryQuantity;
                        $stmt = $db->prepare($sql19);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->bindParam(':stockQuantity', $stockQuantity);
                        $stmt->execute();
                        break;
                    case 'RENENS':
                        $stmt = $db->prepare($sql20);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->execute();
                        $item = $stmt->fetch(PDO::FETCH_OBJ);
                        $stockQuantity = $item->stockQuantity + $deliveryQuantity;
                        $stmt = $db->prepare($sql21);
                        $stmt->bindParam(':product', $product->designation);
                        $stmt->bindParam(':stockQuantity', $stockQuantity);
                        $stmt->execute();
                        break;
                }
                echo '{"notice": {"text": "Quantité mise à jour", "deliveryDate": "'.date("Y-m-d").'"}}';
            } else  {
                echo '{"error": {"text": "Quantité en stock insuffisante"}}';
            }
        }
         $db = null;
        
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Update Product Cost
$app->put('/product/updateCost', function(Request $request, Response $response)
{

    $productId = $request->getParam('productId');
    $cost = $request->getParam('cost');
    $sql = "UPDATE products SET cost = :cost WHERE  productId = :productId";
    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':productId', $productId);
        $stmt->bindParam(':cost', $cost);
        $stmt->execute();
        $db = null;
        echo '{"notice": {"text": "Co&ucirc;t mis à jour"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Delete Product
$app->delete('/product/delete/{productId}', function(Request $request, Response $response)
{
    $productId  = $request->getAttribute('productId');
    $sql = "DELETE FROM products WHERE productId = $productId";
    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $db = null;
        echo '{"notice": {"text": "produit Supprimé"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

/* ------------------
    Order
--------------------*/
// Get All Orders
$app->get('/orders', function(Request $request, Response $response)
{
    $sql = "SELECT * FROM orders ORDER BY orderId DESC";
    $sql2 = "SELECT * FROM goods WHERE orderId = :orderId ";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt    = $db->query($sql);
        $orders = $stmt->fetchAll(PDO::FETCH_OBJ);
        $index = 0;
        foreach($orders as $order) {
            $state = 1;
            $stmt = $db->prepare($sql2);
            $stmt->bindParam(':orderId', $order->orderId);
            $stmt->execute();
            $goods = $stmt->fetchAll(PDO::FETCH_OBJ);
            foreach($goods as $good) {
				$state = $state && $good->state;
            }
            $orders[$index]->state = ($state) ? "1" : "0";
            $orders[$index]->goods = $goods;
            $index++;
        }
        $db      = null;
        echo json_encode($orders);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Get Orders By Client
$app->post('/orders/history', function(Request $request, Response $response)
{
    $clientName  = $request->getParam('clientName');
    $sql = "SELECT * FROM orders WHERE clientName = :clientName ORDER BY orderId DESC";
    $sql2 = "SELECT * FROM goods WHERE orderId = :orderId ";
    $sql3 = "SELECT cost FROM products WHERE designation = :designation";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':clientName', $clientName);
        $stmt->execute();
        $orders = $stmt->fetchAll(PDO::FETCH_OBJ);
        $index = 0;
        foreach($orders as $order) {
            $state = 1;
			$total = 0;
            $stmt = $db->prepare($sql2);
            $stmt->bindParam(':orderId', $order->orderId);
            $stmt->execute();
            $goods = $stmt->fetchAll(PDO::FETCH_OBJ);
            foreach($goods as $good) {
				$state = $state && $good->state;
				$stmt3 = $db->prepare($sql3);
				$stmt3->bindParam(':designation', $good->productDesignation);
				$stmt3->execute();
				$costs = $stmt3->fetch(PDO::FETCH_OBJ);				
				$total += $costs->cost * $good->orderQuantity;
            }
            $orders[$index]->state = ($state) ? "1" : "0";
			$orders[$index]->total = number_format($total, 2, '.', '');
            $orders[$index]->goods = $goods;
            $index++;
        }
        $db      = null;
        echo json_encode($orders);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Get Single Order
$app->get('/goods/{orderId}', function(Request $request, Response $response)
{
    $orderId  = $request->getAttribute('orderId');
    $sql = "SELECT * FROM orders WHERE orderId = $orderId";
    $sql2 = "SELECT * FROM goods WHERE orderId = $orderId";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt    = $db->query($sql);
        $order = $stmt->fetch(PDO::FETCH_OBJ);
        $index = 0;
        $state = 1;
        $stmt    = $db->query($sql2);
        $goods = $stmt->fetchAll(PDO::FETCH_OBJ);
        foreach($goods as $good) {
            $state = $state && $good->state;
        }
        $order->state = ($state) ? "1" : "0";
        $order->goods = $goods;
        $index++;
        $db      = null;
        echo json_encode($order);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});


// Add Order
$app->post('/order/add', function(Request $request, Response $response)
{
	$goods = $request->getParam('goods');
    $clientName = $request->getParam('clientName');
    $sql = "INSERT INTO orders (clientName, orderDate) VALUES (:clientName, NOW())";
    $sql2 = "INSERT INTO goods (orderId, productDesignation, orderQuantity, deliveryQuantity, deliveryDate, state) VALUES (:orderId, :productDesignation, :quantity, 0, '', 0)";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':clientName', $clientName);
        $stmt->execute();
        $orderId = $db->lastInsertId();
        foreach($goods as $good) {
			$stmt = $db->prepare($sql2);
            $stmt->bindParam(':orderId', $orderId);
            $stmt->bindParam(':productDesignation', $good['designation']);
            $stmt->bindParam(':quantity', $good['quantity']);
            $stmt->execute();
        }
        $db      = null;
        echo '{"notice": {"text": "Commande Ajoutée"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

/* ------------------
    Dashboard
--------------------*/
// Get All Stats
$app->get('/dashboard', function(Request $request, Response $response)
{
    
    $sql = "SELECT COUNT(productId) AS numberOfProducts FROM products";
    $sql2 = "SELECT COUNT(clientId) AS numberOfClients FROM clients";
    $sql3 = "SELECT * FROM orders";
    $sql4 = "SELECT COUNT(goodId) AS numberOfGoods FROM goods WHERE state = 0 AND orderId = :orderId";
    $sql5 = "SELECT productDesignation, SUM(orderQuantity) AS orderQuantity FROM goods WHERE state = 0 GROUP BY productDesignation";
    $sql6 = "SELECT quantity FROM products WHERE designation = :productDesignation";
    $stats = array();
    $numberOfOrders = 0;
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt = $db->query($sql);
        $product = $stmt->fetch(PDO::FETCH_OBJ);
        $stats['numberOfProducts'] = $product->numberOfProducts;
        $stmt = $db->query($sql2);
        $client = $stmt->fetch(PDO::FETCH_OBJ);
        $stats['numberOfClients'] = $client->numberOfClients;
        $stmt = $db->query($sql3);
        $orders = $stmt->fetchAll(PDO::FETCH_OBJ);
        foreach($orders as $order) {
            $stmt = $db->prepare($sql4);
            $stmt->bindParam(':orderId', $order->orderId);
            $stmt->execute();
            $good = $stmt->fetch(PDO::FETCH_OBJ);
            if($good->numberOfGoods != 0)  {
                $numberOfOrders++;
            }
        }
        $stats['numberOfOrders'] = "$numberOfOrders";
        $stats['numberOfProducts'] = $product->numberOfProducts;
        $stmt = $db->query($sql5);
        $goods = $stmt->fetchAll(PDO::FETCH_OBJ);
        $index = 0;
        foreach($goods as $good) {
            $stmt = $db->prepare($sql6);
            $stmt->bindParam(':productDesignation', $good->productDesignation);
            $stmt->execute();
            $product = $stmt->fetch(PDO::FETCH_OBJ);
            $goods[$index]->productQuantity = $product->quantity;
            $replenishment = $product->quantity - $good->orderQuantity;
            $goods[$index]->replenishment = "$replenishment";
            $index++;
        }
        $stats['products'] = $goods;
        $db      = null;
        echo json_encode($stats);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

/* ------------------
    Stock
--------------------*/
// Get All Stock By Client
$app->post('/stocks', function(Request $request, Response $response)
{
    $clientName  = $request->getParam('clientName');
    switch ($clientName) {
        case 'BALEXERT':
            $sql = "SELECT * FROM stock_balexert";
            break;
        case 'FRIBOURG':
            $sql = "SELECT * FROM stock_fribourg";
            break;
        case 'LAUSANNE':
            $sql = "SELECT * FROM stock_lausanne";
            break;
        case 'PAQUIS':
            $sql = "SELECT * FROM stock_paquis";
            break;
        case 'PLAINPALAIS':
            $sql = "SELECT * FROM stock_plainpalais";
            break;
        case 'RENENS':
            $sql = "SELECT * FROM stock_renens";
            break;
    }
	$sql2 = "SELECT cost FROM products WHERE designation = :designation";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt    = $db->query($sql);
        $stocks = $stmt->fetchAll(PDO::FETCH_OBJ);
		$index = 0;
        foreach($stocks as $stock) {
            $stmt2 = $db->prepare($sql2);
            $stmt2->bindParam(':designation', $stock->product);
            $stmt2->execute();
			$costs = $stmt2->fetch(PDO::FETCH_OBJ);
            $stocks[$index]->cost = number_format($costs->cost, 2, '.', '');
            $index++;
        }
        $db      = null;
        echo json_encode($stocks);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Stock Add By Client
$app->post('/stock/add', function(Request $request, Response $response)
{
    $clientName  = $request->getParam('clientName');
    $product  = $request->getParam('product');
    $packaging  = $request->getParam('packaging');
    $quantity  = $request->getParam('quantity');
    $limite  = $request->getParam('limite');
    switch ($clientName) {
        case 'BALEXERT':
            $sql = "INSERT INTO stock_balexert (product, packaging, stockQuantity, limite) VALUES (:product, :packaging, :stockQuantity, :limite)";
            break;
        case 'FRIBOURG':
            $sql = "INSERT INTO stock_fribourg (product, packaging, stockQuantity, limite) VALUES (:product, :packaging, :stockQuantity, :limite)";
            break;
        case 'LAUSANNE':
            $sql = "INSERT INTO stock_lausanne (product, packaging, stockQuantity, limite) VALUES (:product, :packaging, :stockQuantity, :limite)";
            break;
        case 'PAQUIS':
            $sql = "INSERT INTO stock_paquis (product, packaging, stockQuantity, limite) VALUES (:product, :packaging, :stockQuantity, :limite)";
            break;
        case 'PLAINPALAIS':
            $sql = "INSERT INTO stock_plainpalais (product, packaging, stockQuantity, limite) VALUES (:product, :packaging, :stockQuantity, :limite)";
            break;
        case 'RENENS':
            $sql = "INSERT INTO stock_renens (product, packaging, stockQuantity, limite) VALUES (:product, :packaging, :stockQuantity, :limite)";
            break;
    }
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':product', $product);
        $stmt->bindParam(':packaging', $packaging);
        $stmt->bindParam(':stockQuantity', $quantity);
        $stmt->bindParam(':limite', $limite);
        $stmt->execute();
        $id = $db->lastInsertId();
        $db      = null;
        echo '{"notice": {"text": "Stock Ajouté", "id": ' . $id . '}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Update Stock By Client
$app->put('/stock/update/{stockId}', function(Request $request, Response $response)
{
    $stockId  = $request->getAttribute('stockId');
    $clientName  = $request->getParam('clientName');
    $quantity  = $request->getParam('quantity');
    $limite  = $request->getParam('limite');
    switch ($clientName) {
        case 'BALEXERT':
            $sql = "UPDATE stock_balexert SET stockQuantity = :stockQuantity, limite = :limite WHERE stockId = $stockId";
            break;
        case 'FRIBOURG':
            $sql = "UPDATE stock_fribourg SET stockQuantity = :stockQuantity, limite = :limite WHERE stockId = $stockId";
            break;
        case 'LAUSANNE':
            $sql = "UPDATE stock_lausanne SET stockQuantity = :stockQuantity, limite = :limite WHERE stockId = $stockId";
            break;
        case 'PAQUIS':
            $sql = "UPDATE stock_paquis SET stockQuantity = :stockQuantity, limite = :limite WHERE stockId = $stockId";
            break;
        case 'PLAINPALAIS':
            $sql = "UPDATE stock_plainpalais SET stockQuantity = :stockQuantity, limite = :limite WHERE stockId = $stockId";
            break;
        case 'RENENS':
            $sql = "UPDATE stock_renens SET stockQuantity = :stockQuantity, limite = :limite WHERE stockId = $stockId";
            break;
    }
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':stockQuantity', $quantity);
        $stmt->bindParam(':limite', $limite);
        $stmt->execute(); 
        $db      = null;
        echo '{"notice": {"text": "Stock mis à jour"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Debit Stock By Client
/*$app->put('/stock/debit', function(Request $request, Response $response)
{
    $order  = $request->getParam('order');
    $clientName  = $request->getParam('clientName');
    $modeConsommation = $request->getParam('modeConsommation');
    $goods = explode("#!",$order);
    $i = 2;
    while($i < sizeOf($goods)) {
        array_splice($goods,$i,2);
        $i = $i + 1;
        array_splice($goods,$i,1);
        $i = $i + 2;
    }
    $goodsTemp = array();
    $supreme = 0;
    for($i = 0; $i < sizeOf($goods); $i = $i + 3) {
    	if($goods[$i+2] == "non") {
			if(is_numeric (stripos($goods[$i+1],"supreme"))) {
				$supreme = 1;
	    	} else  {
	    		$supreme = 0;
    		}    	
    	}
    	if($supreme) {
    		$quantitySupreme = $goods[$i];
    	} else {
    		$quantitySupreme = 0;
    	}
        $key = array_search($goods[$i+1], $goodsTemp, true); 
        if (!is_numeric($key)) {
          array_push($goodsTemp,$goods[$i+1],$goods[$i] - $quantitySupreme,$quantitySupreme);
        } else {
          $goodsTemp[$key+1] += $goods[$i] - $quantitySupreme;
          $goodsTemp[$key+2] += $quantitySupreme;
        }
    }
    $goods = $goodsTemp;
    //print_r($goods);
    switch ($clientName) {
        case 'BALEXERT':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_balexert WHERE product = :product";
            $sql3 = "UPDATE stock_balexert SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'FRIBOURG':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_fribourg WHERE product = :product";
            $sql3 = "UPDATE stock_fribourg SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'LAUSANNE':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_lausanne WHERE product = :product";
            $sql3 = "UPDATE stock_lausanne SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'PAQUIS':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_paquis WHERE product = :product";
            $sql3 = "UPDATE stock_paquis SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'PLAINPALAIS':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_plainpalais WHERE product = :product";
            $sql3 = "UPDATE stock_plainpalais SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'RENENS':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_renens WHERE product = :product";
            $sql3 = "UPDATE stock_renens SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
    }
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $ingredients = array();
        for($i = 0; $i < sizeOf($goods); $i = $i + 3) {
        	$orderQuantity = $goods[$i+1];
    		$orderQuantitySupreme = $goods[$i+2];	
            $menu = $goods[$i];
            $stmt = $db->prepare($sql);
            $stmt->bindParam(':clientName', $clientName);
            $stmt->bindParam(':menu', $menu);
            $stmt->execute();
            $raws = $stmt->fetchAll(PDO::FETCH_OBJ);
            if($stmt->rowCount() != 0) {
                foreach($raws as $raw) {
                	$key2 = array_search($raw->product, $ingredients, true);
                	if (!is_numeric($key2)) {
      				    array_push($ingredients,$raw->product,$orderQuantity,$orderQuantitySupreme,$raw->restriction,$raw->quantity,$raw->quantitySupreme,$raw->modeConsommation);
                    } else {
			          $ingredients[$key2+1] += $orderQuantity;
			          $ingredients[$key2+2] += $orderQuantitySupreme;
                    }
                }
            }
        }
        for($i = 0; $i < sizeOf($ingredients); $i = $i + 7) {
        	$productName =  $ingredients[$i];
        	$orderQuantity = $ingredients[$i+1];
        	$orderQuantitySupreme = $ingredients[$i+2];
        	$restriction= $ingredients[$i+3];
        	$quantity = $ingredients[$i+4];
        	$quantitySupreme = $ingredients[$i+5];
        	$modesConsommation = $ingredients[$i+6];
            $key3 = array_search($restriction, $goods, true);
        	if ($restriction != "-" && is_numeric($key3)) {
            	$restrictQuantity = $orderQuantity - $goods[$key3+1];                           
            	$restrictQuantitySupreme = $orderQuantitySupreme - $goods[$key3+2];
            } else {
                $restrictQuantity = $orderQuantity;                           
                $restrictQuantitySupreme = $orderQuantitySupreme;                           
            }
			$stmt2 = $db->prepare($sql2);
	        $stmt2->bindParam(':product', $productName);
	        $stmt2->execute();
	        $product = $stmt2->fetch(PDO::FETCH_OBJ);
	        if($stmt2->rowCount() != 0)  {
            	$restrictQuantityTotal = ($restrictQuantity / $quantity) + ($restrictQuantitySupreme / $quantitySupreme);
                $newQuantity = $product->stockQuantity - $restrictQuantityTotal;
                if($newQuantity < 0)  {
                    $newQuantity = 0;
                }
                //echo $productName."-".$restrictQuantity."-".$restrictQuantitySupreme."\n";
                $modesConsommations = explode(", ",$modesConsommation);
                if (in_array($modeConsommation, $modesConsommations)) {
                    $stmt3 = $db->prepare($sql3);
                    $stmt3->bindParam(':product', $productName);
                    $stmt3->bindParam(':stockQuantity', number_format($newQuantity,5));
                    $stmt3->execute();
                }
	        }
        }
        $db      = null;
        echo '{"notice": {"text": "Stock mis à jour"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});*/

// Debit Stock By Client
$app->put('/stock/debit', function(Request $request, Response $response)
{
    $order  = $request->getParam('order');
    $clientName  = $request->getParam('clientName');
    $modeConsommation = $request->getParam('modeConsommation');
    $goods = explode("#!",$order);
    $i = 2;
    while($i < sizeOf($goods)) {
        array_splice($goods,$i,1);
        $i = $i + 2;
        array_splice($goods,$i,1);
        $i = $i + 2;
    }
	$goods3 = explode("#!",$order);
	$k = 0;
	$tabIndex = -1;
	$ratios = array();
    while($k < sizeOf($goods3)) {
      if($goods3[$k+4] == "non") {
		  $tabIndex++;
		  $ratios[$tabIndex] = 0;
	  } else {
		  if(is_numeric (stripos($goods3[$k+2],"tacos")) and is_numeric (stripos($goods3[$k+3],"viande")) and $tabIndex != -1)  {
          $ratios[$tabIndex] = $ratios[$tabIndex] + 1;	  
        	} 
	  }
	  $k++;
    }
    $goodsTemp = array();
    $supreme = 0;
	$ratioIndex = -1;
    for($i = 0; $i < sizeOf($goods); $i = $i + 4) {
        if($goods[$i+3] == "non") {
            $ratio = 1;
			$ratioIndex++;
            //Case Supreme
            if(is_numeric (stripos($goods[$i+1],"supreme"))) {
                $supreme = 1;
            } else  {
                $supreme = 0;
            }    
            //Case Simple   
            if(is_numeric (stripos($goods[$i+1],"simple"))) {
                $simple = 1;
            } else  {
                $simple = 0;
            }    
            //Case Double
            if(is_numeric (stripos($goods[$i+1],"double"))) {
                $double = 1;
            } else  {
                $double = 0;
            }    
            //Case Supreme
            if(is_numeric (stripos($goods[$i+1],"supreme")) and !stripos($goods[$i+1],"max")) {
                $supreme2 = 1;
            } else  {
                $supreme2 = 0;
            }    
            //Case Supreme Max
            if(is_numeric (stripos($goods[$i+1],"max"))) {
                $max = 1;
            } else  {
                $max = 0;
            }    
        }
        else {
            if(is_numeric (stripos($goods[$i+2],"viande")) and $ratioIndex != -1 and $ratios[$ratioIndex] !=0) {
                if($simple) {
                    $ratio = 1;
                }
                if($double) {
                    $ratio = 2 / $ratios[$ratioIndex];
                }
                if($supreme2) {
                    $ratio = 3 / $ratios[$ratioIndex];
                }
                if($max == 1) {
                    $ratio = 5 / $ratios[$ratioIndex];
                }
            } else  {
				$ratio = 1;
			}
        }
        if($supreme) {
            $quantitySupreme = $goods[$i];
        } else {
            $quantitySupreme = 0;
        }
        $key = array_search($goods[$i+1], $goodsTemp, true); 
        if (!is_numeric($key)) {
          array_push($goodsTemp,$goods[$i+1],$goods[$i] - $quantitySupreme,$quantitySupreme,$ratio);
        } else {
          $goodsTemp[$key+1] += $goods[$i] - $quantitySupreme;
          $goodsTemp[$key+2] += $quantitySupreme;
          $goodsTemp[$key+3] += $ratio;
        }
    }
    $goods = $goodsTemp;
    //print_r($goods);
    switch ($clientName) {
        case 'BALEXERT':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_balexert WHERE product = :product";
            $sql3 = "UPDATE stock_balexert SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'FRIBOURG':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_fribourg WHERE product = :product";
            $sql3 = "UPDATE stock_fribourg SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'LAUSANNE':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_lausanne WHERE product = :product";
            $sql3 = "UPDATE stock_lausanne SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'PAQUIS':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_paquis WHERE product = :product";
            $sql3 = "UPDATE stock_paquis SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'PLAINPALAIS':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_plainpalais WHERE product = :product";
            $sql3 = "UPDATE stock_plainpalais SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
        case 'RENENS':
            $sql = "SELECT * FROM raws WHERE clientName = :clientName AND menu = :menu";
            $sql2 = "SELECT stockQuantity FROM stock_renens WHERE product = :product";
            $sql3 = "UPDATE stock_renens SET stockQuantity = :stockQuantity WHERE product = :product";
            break;
    }
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $ingredients = array();
        for($i = 0; $i < sizeOf($goods); $i = $i + 4) {
            $orderQuantity = $goods[$i+1] * $goods[$i+3];
            $orderQuantitySupreme = $goods[$i+2] * $goods[$i+3];   
            $menu = $goods[$i];
            $stmt = $db->prepare($sql);
            $stmt->bindParam(':clientName', $clientName);
            $stmt->bindParam(':menu', $menu);
            $stmt->execute();
            $raws = $stmt->fetchAll(PDO::FETCH_OBJ);
            if($stmt->rowCount() != 0) {
                foreach($raws as $raw) {
                    $key2 = array_search($raw->product, $ingredients, true);
                    if (!is_numeric($key2)) {
                        array_push($ingredients,$raw->product,$orderQuantity,$orderQuantitySupreme,$raw->restriction,$raw->quantity,$raw->quantitySupreme,$raw->modeConsommation);
                    } else {
                      $ingredients[$key2+1] += $orderQuantity;
                      $ingredients[$key2+2] += $orderQuantitySupreme;
                    }
                }
            }
        }
        for($i = 0; $i < sizeOf($ingredients); $i = $i + 7) {
            $productName =  $ingredients[$i];
            $orderQuantity = $ingredients[$i+1];
            $orderQuantitySupreme = $ingredients[$i+2];
            $restriction= $ingredients[$i+3];
            $quantity = $ingredients[$i+4];
            $quantitySupreme = $ingredients[$i+5];
            $modesConsommation = $ingredients[$i+6];
            $key3 = array_search($restriction, $goods, true);
            if ($restriction != "-" && is_numeric($key3)) {
                $restrictQuantity = $orderQuantity - $goods[$key3+1];                           
                $restrictQuantitySupreme = $orderQuantitySupreme - $goods[$key3+2];
            } else {
                $restrictQuantity = $orderQuantity;                           
                $restrictQuantitySupreme = $orderQuantitySupreme;                           
            }
            $stmt2 = $db->prepare($sql2);
            $stmt2->bindParam(':product', $productName);
            $stmt2->execute();
            $product = $stmt2->fetch(PDO::FETCH_OBJ);
            if($stmt2->rowCount() != 0)  {
                $restrictQuantityTotal = ($restrictQuantity / $quantity) + ($restrictQuantitySupreme / $quantitySupreme);
                $newQuantity = $product->stockQuantity - $restrictQuantityTotal;
                if($newQuantity < 0)  {
                    $newQuantity = 0;
                }
                //echo $productName."-".$restrictQuantity."-".$restrictQuantitySupreme."\n";
                $modesConsommations = explode(", ",$modesConsommation);
                if (in_array($modeConsommation, $modesConsommations)) {
                    $stmt3 = $db->prepare($sql3);
                    $stmt3->bindParam(':product', $productName);
                    $stmt3->bindParam(':stockQuantity', number_format($newQuantity,5));
                    $stmt3->execute();
                }
            }
        }
        $db      = null;
        echo '{"notice": {"text": "Stock mis à jour"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Delete Stock By Client
$app->delete('/stock/delete/{stockId}', function(Request $request, Response $response)
{
    $stockId  = $request->getAttribute('stockId');
    $clientName  = $request->getParam('clientName');
    switch ($clientName) {
        case 'BALEXERT':
            $sql = "DELETE FROM stock_balexert WHERE stockId = $stockId";
            break;
        case 'FRIBOURG':
            $sql = "DELETE FROM stock_fribourg WHERE stockId = $stockId";
            break;
        case 'LAUSANNE':
            $sql = "DELETE FROM stock_lausanne WHERE stockId = $stockId";
            break;
        case 'PAQUIS':
            $sql = "DELETE FROM stock_paquis WHERE stockId = $stockId";
            break;
        case 'PLAINPALAIS':
            $sql = "DELETE FROM stock_plainpalais WHERE stockId = $stockId";
            break;
        case 'RENENS':
            $sql = "DELETE FROM stock_renens WHERE stockId = $stockId";
            break;
    }
    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $db = null;
        echo '{"notice": {"text": "Stock Supprimé"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

/* ------------------
    raw
--------------------*/
// Get All Raws By Client
$app->post('/raws', function(Request $request, Response $response)
{
    $clientName  = $request->getParam('clientName');
    $sql = "SELECT * FROM raws WHERE clientName = :clientName";
           
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':clientName', $clientName);
        $stmt->execute();
        $raws = $stmt->fetchAll(PDO::FETCH_OBJ);
        $db      = null;
		echo json_encode($raws);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Raw Add By Client
$app->post('/raw/add', function(Request $request, Response $response)
{
    $clientName  = $request->getParam('clientName');
    $product  = $request->getParam('product');
    $menu  = $request->getParam('menu');
    $quantity  = $request->getParam('quantity');
    $quantitySupreme  = $request->getParam('quantitySupreme');
    $modeConsommation  = $request->getParam('modeConsommation');
    $restriction  = $request->getParam('restriction');
    $sql = "INSERT INTO raws (clientName, product, menu, quantity, quantitySupreme, modeConsommation, restriction) VALUES (:clientName, :product, :menu, :quantity, :quantitySupreme, :modeConsommation, :restriction)";
    try {
        // Get DB Object
        $db      = new db();
        // Connect
        $db      = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->bindParam(':clientName', $clientName);
        $stmt->bindParam(':product', $product);
        $stmt->bindParam(':menu', $menu);
        $stmt->bindParam(':quantity', $quantity);
        $stmt->bindParam(':quantitySupreme', $quantitySupreme);
        $stmt->bindParam(':modeConsommation', $modeConsommation);
        $stmt->bindParam(':restriction', $restriction);
        $stmt->execute();
        $id = $db->lastInsertId();
        $db      = null;
        echo '{"notice": {"text": "Matière Première Ajouté", "id": ' . $id . '}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

// Delete Stock By Id
$app->delete('/raw/delete/{rawId}', function(Request $request, Response $response)
{
    $rawId  = $request->getAttribute('rawId');
    $sql = "DELETE FROM raws WHERE rawId = $rawId";
            
    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
        $stmt = $db->prepare($sql);
        $stmt->execute();
        $db = null;
        echo '{"notice": {"text": "Matière Première Supprimé"}}';
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});

/* ------------------
    Exports
--------------------*/
// Get Exports Data
// Delete Stock By Id
$app->post('/exports', function(Request $request, Response $response)
{
    $product  = $request->getParam('product');
    $startDate  = $request->getParam('startDate');
    $endDate  = $request->getParam('endDate');
    $mode  = $request->getParam('mode');
	
	//Tous Global
	$sql = "SELECT DISTINCT productDesignation FROM records
			WHERE recordDate >= '$startDate' AND
				  recordDate <= '$endDate'";
	
	//Tous Detail
	$sql3 = "SELECT * FROM records
			 WHERE recordDate >= '$startDate' AND
				  recordDate <= '$endDate'";
	
	//Produit Global
	$sql4 = "SELECT SUM(quantity) AS 'in' FROM records 
			WHERE type ='in' AND 
				  recordDate >= '$startDate' AND
				  recordDate <= '$endDate' AND
				  productDesignation = :produit";
	$sql5 = "SELECT SUM(quantity)  AS 'out' FROM records
			WHERE type ='out' AND
				  recordDate >= '$startDate' AND
				  recordDate <= '$endDate' AND
				  productDesignation = :produit";

	//Produit Detail
	$sql6 = "SELECT * FROM records
			WHERE productDesignation = :produit AND
			recordDate >= '$startDate' AND
			recordDate <= '$endDate'";
	
	$sql7 = "SELECT cost FROM products WHERE designation = :produit";


    try {
        // Get DB Object
        $db   = new db();
        // Connect
        $db   = $db->connect();
		if($product){
			if($mode==1){
				//produit global
				$records = array();
				$records['productDesignation'] = $product;
				$stmt2 = $db->prepare($sql4);
				$stmt2->bindParam(':produit', $product);
				$stmt2->execute();
				$costs = $stmt2->fetch(PDO::FETCH_OBJ);
				$in = ($costs->in==null) ? 0 : $costs->in;
				$records['in'] = $in;
				$stmt4 = $db->prepare($sql7);
				$stmt4->bindParam(':produit', $product);
				$stmt4->execute();
				$costs = $stmt4->fetch(PDO::FETCH_OBJ);
				$cost = $costs->cost*$in;
				$records['costIn'] = number_format($cost, 2, '.', '');
				$stmt3 = $db->prepare($sql5);
				$stmt3->bindParam(':produit', $product);
				$stmt3->execute();
				$costs = $stmt3->fetch(PDO::FETCH_OBJ);
				$out = ($costs->out==null) ? 0 : $costs->out;
				$records['out'] =  $out;
				$stmt4 = $db->prepare($sql7);
				$stmt4->bindParam(':produit', $product);
				$stmt4->execute();
				$costs = $stmt4->fetch(PDO::FETCH_OBJ);
				$cost = $costs->cost*$out;
				$records['costOut'] = number_format($cost, 2, '.', '');
			} 
			if($mode==2){
				//produit detail
				$stmt = $db->prepare($sql6);
				$stmt->bindParam(':produit', $product);
        		$stmt->execute();
        		$records = $stmt->fetchAll(PDO::FETCH_OBJ);
				$index = 0;
				foreach($records as $record) {
					$stmt2 = $db->prepare($sql7);
					$stmt2->bindParam(':produit', $record->productDesignation);
					$stmt2->execute();
					$costs = $stmt2->fetch(PDO::FETCH_OBJ);
					$cost = $costs->cost*$record->quantity;
					$records[$index]->cost = number_format($cost, 2, '.', '');
					$index++;
				}	
			}
		} else {
			if($mode==1){
				//tous global
				$result = array();
				$stmt = $db->prepare($sql);
        		$stmt->execute();
        		$records = $stmt->fetchAll(PDO::FETCH_OBJ);
				$index = 0;
				foreach($records as $record) {
					$stmt2 = $db->prepare($sql4);
					$stmt2->bindParam(':produit', $record->productDesignation);
					$stmt2->execute();
					$costs = $stmt2->fetch(PDO::FETCH_OBJ);
					$in = ($costs->in==null) ? 0 : $costs->in;
					$records[$index]->in = $in;
					$stmt4 = $db->prepare($sql7);
					$stmt4->bindParam(':produit', $record->productDesignation);
					$stmt4->execute();
					$costs = $stmt4->fetch(PDO::FETCH_OBJ);
					$cost = $costs->cost*$in;
					$records[$index]->costIn = number_format($cost, 2, '.', '');
					$stmt3 = $db->prepare($sql5);
					$stmt3->bindParam(':produit', $record->productDesignation);
					$stmt3->execute();
					$costs = $stmt3->fetch(PDO::FETCH_OBJ);
					$out = ($costs->out==null) ? 0 : $costs->out;
					$records[$index]->out =  $out;
					$stmt4 = $db->prepare($sql7);
					$stmt4->bindParam(':produit', $record->productDesignation);
					$stmt4->execute();
					$costs = $stmt4->fetch(PDO::FETCH_OBJ);
					$cost = $costs->cost*$out;
					$records[$index]->costOut = number_format($cost, 2, '.', '');
					$index++;
				}
				//$records = $result;
			}
			if($mode==2){
				//tous detail"
				$stmt = $db->prepare($sql3);
        		$stmt->execute();
        		$records = $stmt->fetchAll(PDO::FETCH_OBJ);
				$index = 0;
				foreach($records as $record) {
					$stmt2 = $db->prepare($sql7);
					$stmt2->bindParam(':produit', $record->productDesignation);
					$stmt2->execute();
					$costs = $stmt2->fetch(PDO::FETCH_OBJ);
					$cost = $costs->cost*$record->quantity;
					$records[$index]->cost = number_format($cost, 2, '.', '');
					$index++;
				}
			}
			
		}

        $db      = null;
		echo json_encode($records);
    }
    catch (PDOException $e) {
        echo '{"error": {"text": "' . $e->getMessage() . '"}}';
    }
});