/* ================================================================================================
	FONCTIONS INITIALISATION
   ================================================================================================ */
$(document).ready(function() {
  var preferences = ["Mozza sticks", "Jalapenos", "Bouchees camembert", "undefined",
					"Serviettes", "Sacs plastiques", "Bobine essuie tout", "Rouleaux thermiques",
					"Tabliers jetables", "Rouleau aluminium", "Film alimentaire", "Sauces", "Sticks Sauces", "Galettes Tortillas", 
					"Pains burger", "Mayonnaise 5L", "Ketchup 5L", "Cache Barbes", "Charlottes", "Gants latex", "Sacs poubelles",
					"Fromage Rapé", "Cheddar Dairy 88tr","Vache qui rit 1kg", "Boursin 1kg", "Pochettes frites", "Boite Menu Kids",
					"Coquille Hamburger en carton", "Coquille isotherme", "Eaux aromatisees", "Boite tarte", "Papier ingraissable",
					"Tiramisu Nubi", "Eau de source", "Sacs poubelles", "Pochettes frites", "Boite Hamburger en carton", "Sacs Kraft"];
  $('#export').on('click', function() {
    exporter();
  });

  $('.item input[type=checkbox]').on('click', function() {
	  
    if (this.checked) {
      if ($(this.closest("tr")).attr("description") == "Sauces") {
        $("#sauces").find("input").removeAttr("disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Sticks Sauces") {
        $("#sticks-sauces").find("input").removeAttr("disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Coquille isotherme") {
        $("#coquille-isotherme").find("input").removeAttr("disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Sacs Kraft") {
        $("#sacs-kraft").find("input").removeAttr("disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Eaux aromatisees") {
        $("#eaux-aromatisees").find("input").removeAttr("disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Pains burger") {
        $("#pains").find("input").removeAttr("disabled");
      }
      $(this.closest("tr")).find(".quantity input").removeAttr("disabled");
      $(this.closest("tr")).find(".preference input[type=checkbox]").removeAttr("disabled");
	  if (preferences.indexOf($(this.closest("tr")).attr("description")) != -1) {
        $(this.closest("tr")).find(".preference input[type=checkbox]").click();
      }
    } else {
      if ($(this.closest("tr")).attr("description") == "Sauces") {
        $("#sauces").find("input").val(0);
        $("#sauces").find("input").attr("disabled", "disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Sticks Sauces") {
        $("#sticks-sauces").find("input").val(0);
        $("#sticks-sauces").find("input").attr("disabled", "disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Coquille isotherme") {
        $("#coquille-isotherme").find("input").val(0);
        $("#coquille-isotherme").find("input").attr("disabled", "disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Eaux aromatisees") {
        $("#eaux-aromatisees").find("input").val(0);
        $("#eaux-aromatisees").find("input").attr("disabled", "disabled");
      }
      if ($(this.closest("tr")).attr("description") == "Pains burger") {
        $("#pains").find("input").val(0);
        $("#pains").find("input").attr("disabled", "disabled");
      }
      $(this.closest("tr")).find(".grossMass input").val(0);
      $(this.closest("tr")).find(".netMass input").val(0);
      $(this.closest("tr")).find(".statisticalValue input").val(0);
      $(this.closest("tr")).find(".vatValue input").val(0);
      $(this.closest("tr")).find(".quantity input").val(0);
      $(this.closest("tr")).find(".quantity input").attr("disabled", "disabled");
      if ($(this.closest("tr")).find(".preference input[type=checkbox]:checked").length == 1) {
        $(this.closest("tr")).find(".preference input[type=checkbox]").click();
      }
      $(this.closest("tr")).find(".preference input").attr("disabled", "disabled");
    }
  });
  $('.preference input[type=checkbox]').on('click', function() {
    if (this.checked) {
      $(this.closest("tr")).find(".preference input[type!=checkbox]").removeAttr("disabled");
    } else {
      $(this.closest("tr")).find(".preference input[type!=checkbox]").attr("disabled", "disabled");
    }
  });
  $('#exchangeRate').on('change', function() {
    exchangeRate = $(this).val();
    $('input[type=checkbox]:checked').each(function(index) {
      tr = $(this.closest("tr"));
      if ($(this.closest("tr")).attr("description") != "Sauces" && $(this.closest("tr")).attr("description") != "Sticks Sauces" && $(this.closest("tr")).attr("description") != "Coquille isotherme" && $(this.closest("tr")).attr("description") != "Eaux aromatisees" && $(this.closest("tr")).attr("description") != "Sacs Kraft" && $(this.closest("tr")).attr("description") != "Pains Burger") {
        statisticalValueUnit = $(this.closest("tr")).attr("statisticalValue");
        quantity = $(this.closest("tr")).find(".quantity input").val();
        statisticalValue = parseFloat(statisticalValueUnit) * quantity * parseFloat(exchangeRate);
        statisticalValue = Math.floor(statisticalValue);
        vatValue = statisticalValue + 3;

        $(this.closest("tr")).find(".statisticalValue input").val(statisticalValue);
        $(this.closest("tr")).find(".vatValue input").val(vatValue);
      } else {
        if (tr.attr("description") == "Sauces") {
          totalQuantity = 0;
          totalGrossMass = 0;
          totalNetMass = 0;
          totalStatisticalValue = 0;
          totalVatValue = 0;
          $("#sauces").find("input").each(function() {
            totalQuantity += parseInt(this.value);
            totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
            totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
            totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
          });
          totalStatisticalValue *= parseFloat(exchangeRate);
          totalStatisticalValue = Math.floor(totalStatisticalValue);
          totalVatValue = totalStatisticalValue + 3;
          $("tr[description=Sauces]").find(".grossMass input").val(totalGrossMass.toFixed(2));
          $("tr[description=Sauces]").find(".netMass input").val(totalNetMass.toFixed(2));
          $("tr[description=Sauces]").find(".statisticalValue input").val(totalStatisticalValue);
          $("tr[description=Sauces]").find(".vatValue input").val(totalVatValue);
          $("tr[description=Sauces]").find(".quantity input").val(totalQuantity);
        }

        if (tr.attr("description") == "Sticks Sauces") {
          totalQuantity = 0;
          totalGrossMass = 0;
          totalNetMass = 0;
          totalStatisticalValue = 0;
          totalVatValue = 0;
          $("#sticks-sauces").find("input").each(function() {
            totalQuantity += parseInt(this.value);
            totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
            totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
            totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
          });
          totalStatisticalValue *= parseFloat(exchangeRate);
          totalStatisticalValue = Math.floor(totalStatisticalValue);
          totalVatValue = totalStatisticalValue + 3;
          $("tr[description^=Sticks]").find(".grossMass input").val(totalGrossMass.toFixed(2));
          $("tr[description^=Sticks]").find(".netMass input").val(totalNetMass.toFixed(2));
          $("tr[description^=Sticks]").find(".statisticalValue input").val(totalStatisticalValue);
          $("tr[description^=Sticks]").find(".vatValue input").val(totalVatValue);
          $("tr[description^=Sticks]").find(".quantity input").val(totalQuantity);
        }

        if (tr.attr("description") == "Coquille isotherme") {
          totalQuantity = 0;
          totalGrossMass = 0;
          totalNetMass = 0;
          totalStatisticalValue = 0;
          totalVatValue = 0;
          $("#coquille-isotherme").find("input").each(function() {
            totalQuantity += parseInt(this.value);
            totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
            totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
            totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
          });
          totalStatisticalValue *= parseFloat(exchangeRate);
          totalStatisticalValue = Math.floor(totalStatisticalValue);
          totalVatValue = totalStatisticalValue + 3;
          $("tr[description^=Coquille]").find(".grossMass input").val(totalGrossMass.toFixed(2));
          $("tr[description^=Coquille]").find(".netMass input").val(totalNetMass.toFixed(2));
          $("tr[description^=Coquille]").find(".statisticalValue input").val(totalStatisticalValue);
          $("tr[description^=Coquille]").find(".vatValue input").val(totalVatValue);
          $("tr[description^=Coquille]").find(".quantity input").val(totalQuantity);
        }

        if (tr.attr("description") == "Sacs Kraft") {
          totalQuantity = 0;
          totalGrossMass = 0;
          totalNetMass = 0;
          totalStatisticalValue = 0;
          totalVatValue = 0;
          $("#sacs-kraft").find("input").each(function() {
            totalQuantity += parseInt(this.value);
            totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
            totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
            totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
          });
          totalStatisticalValue *= parseFloat(exchangeRate);
          totalStatisticalValue = Math.floor(totalStatisticalValue);
          totalVatValue = totalStatisticalValue + 3;
          $("tr[description='Sacs Kraft']").find(".grossMass input").val(totalGrossMass.toFixed(2));
          $("tr[description='Sacs Kraft']").find(".netMass input").val(totalNetMass.toFixed(2));
          $("tr[description='Sacs Kraft']").find(".statisticalValue input").val(totalStatisticalValue);
          $("tr[description='Sacs Kraft']").find(".vatValue input").val(totalVatValue);
          $("tr[description='Sacs Kraft']").find(".quantity input").val(totalQuantity);
        }

        if (tr.attr("description") == "Eaux aromatisees") {
          totalQuantity = 0;
          totalGrossMass = 0;
          totalNetMass = 0;
          totalStatisticalValue = 0;
          totalVatValue = 0;
          $("#eaux-aromatisees").find("input").each(function() {
            totalQuantity += parseInt(this.value);
            totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
            totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
            totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
          });
          totalStatisticalValue *= parseFloat(exchangeRate);
          totalStatisticalValue = Math.floor(totalStatisticalValue);
          totalVatValue = totalStatisticalValue + 3;
          $("tr[description^=Eaux]").find(".grossMass input").val(totalGrossMass.toFixed(2));
          $("tr[description^=Eaux]").find(".netMass input").val(totalNetMass.toFixed(2));
          $("tr[description^=Eaux]").find(".statisticalValue input").val(totalStatisticalValue);
          $("tr[description^=Eaux]").find(".vatValue input").val(totalVatValue);
          $("tr[description^=Eaux]").find(".quantity input").val(totalQuantity);
        }
		
        if (tr.attr("description") == "Pains Burger") {
          totalQuantity = 0;
          totalGrossMass = 0;
          totalNetMass = 0;
          totalStatisticalValue = 0;
          totalVatValue = 0;
          $("#pains").find("input").each(function() {
            totalQuantity += parseInt(this.value);
            totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
            totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
            totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
          });
          totalStatisticalValue *= parseFloat(exchangeRate);
          totalStatisticalValue = Math.floor(totalStatisticalValue);
          totalVatValue = totalStatisticalValue + 3;
          $("tr[description^=Pains]").find(".grossMass input").val(totalGrossMass.toFixed(2));
          $("tr[description^=Pains]").find(".netMass input").val(totalNetMass.toFixed(2));
          $("tr[description^=Pains]").find(".statisticalValue input").val(totalStatisticalValue);
          $("tr[description^=Pains]").find(".vatValue input").val(totalVatValue);
          $("tr[description^=Pains]").find(".quantity input").val(totalQuantity);
        }
      }
    });
  });
  $("#sauces").find("input").on('change', function() {
    exchangeRate = $('#exchangeRate').val();
    totalQuantity = 0;
    totalGrossMass = 0;
    totalNetMass = 0;
    totalStatisticalValue = 0;
    totalVatValue = 0;
    $("#sauces").find("input").each(function() {
      totalQuantity += parseInt(this.value);
      totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
      totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
      totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
    });
    totalStatisticalValue *= parseFloat(exchangeRate);
    totalStatisticalValue = Math.floor(totalStatisticalValue);
    totalVatValue = totalStatisticalValue + 3;
    $("tr[description=Sauces]").find(".grossMass input").val(totalGrossMass.toFixed(2));
    $("tr[description=Sauces]").find(".netMass input").val(totalNetMass.toFixed(2));
    $("tr[description=Sauces]").find(".statisticalValue input").val(totalStatisticalValue);
    $("tr[description=Sauces]").find(".vatValue input").val(totalVatValue);
    $("tr[description=Sauces]").find(".quantity input").val(totalQuantity);
  });
  $("#sticks-sauces").find("input").on('change', function() {
    exchangeRate = $('#exchangeRate').val();
    totalQuantity = 0;
    totalGrossMass = 0;
    totalNetMass = 0;
    totalStatisticalValue = 0;
    totalVatValue = 0;
    $("#sticks-sauces").find("input").each(function() {
      totalQuantity += parseInt(this.value);
      totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
      totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
      totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
    });
    totalStatisticalValue *= parseFloat(exchangeRate);
    totalStatisticalValue = Math.floor(totalStatisticalValue);
    totalVatValue = totalStatisticalValue + 3;
    $("tr[description^=Sticks]").find(".grossMass input").val(totalGrossMass.toFixed(2));
    $("tr[description^=Sticks]").find(".netMass input").val(totalNetMass.toFixed(2));
    $("tr[description^=Sticks]").find(".statisticalValue input").val(totalStatisticalValue);
    $("tr[description^=Sticks]").find(".vatValue input").val(totalVatValue);
    $("tr[description^=Sticks]").find(".quantity input").val(totalQuantity);

  });
  $("#coquille-isotherme").find("input").on('change', function() {
    exchangeRate = $('#exchangeRate').val();
    totalQuantity = 0;
    totalGrossMass = 0;
    totalNetMass = 0;
    totalStatisticalValue = 0;
    totalVatValue = 0;
    $("#coquille-isotherme").find("input").each(function() {
      totalQuantity += parseInt(this.value);
      totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
      totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
      totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
    });
    totalStatisticalValue *= parseFloat(exchangeRate);
    totalStatisticalValue = Math.floor(totalStatisticalValue);
    totalVatValue = totalStatisticalValue + 3;
    $("tr[description^=Coquille]").find(".grossMass input").val(totalGrossMass.toFixed(2));
    $("tr[description^=Coquille]").find(".netMass input").val(totalNetMass.toFixed(2));
    $("tr[description^=Coquille]").find(".statisticalValue input").val(totalStatisticalValue);
    $("tr[description^=Coquille]").find(".vatValue input").val(totalVatValue);
    $("tr[description^=Coquille]").find(".quantity input").val(totalQuantity);

  });
  $("#sacs-kraft").find("input").on('change', function() {
    exchangeRate = $('#exchangeRate').val();
    totalQuantity = 0;
    totalGrossMass = 0;
    totalNetMass = 0;
    totalStatisticalValue = 0;
    totalVatValue = 0;
    $("#sacs-kraft").find("input").each(function() {
      totalQuantity += parseInt(this.value);
      totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
      totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
      totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
    });
    totalStatisticalValue *= parseFloat(exchangeRate);
    totalStatisticalValue = Math.floor(totalStatisticalValue);
    totalVatValue = totalStatisticalValue + 3;
    $("tr[description='Sacs Kraft']").find(".grossMass input").val(totalGrossMass.toFixed(2));
    $("tr[description='Sacs Kraft']").find(".netMass input").val(totalNetMass.toFixed(2));
    $("tr[description='Sacs Kraft']").find(".statisticalValue input").val(totalStatisticalValue);
    $("tr[description='Sacs Kraft']").find(".vatValue input").val(totalVatValue);
    $("tr[description='Sacs Kraft']").find(".quantity input").val(totalQuantity);

  });
  $("#eaux-aromatisees").find("input").on('change', function() {
    exchangeRate = $('#exchangeRate').val();
    totalQuantity = 0;
    totalGrossMass = 0;
    totalNetMass = 0;
    totalStatisticalValue = 0;
    totalVatValue = 0;
    $("#eaux-aromatisees").find("input").each(function() {
      totalQuantity += parseInt(this.value);
      totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
      totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
      totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
    });
    totalStatisticalValue *= parseFloat(exchangeRate);
    totalStatisticalValue = Math.floor(totalStatisticalValue);
    totalVatValue = totalStatisticalValue + 3;
    $("tr[description^=Eaux]").find(".grossMass input").val(totalGrossMass.toFixed(2));
    $("tr[description^=Eaux]").find(".netMass input").val(totalNetMass.toFixed(2));
    $("tr[description^=Eaux]").find(".statisticalValue input").val(totalStatisticalValue);
    $("tr[description^=Eaux]").find(".vatValue input").val(totalVatValue);
    $("tr[description^=Eaux]").find(".quantity input").val(totalQuantity);

  });
  $("#pains").find("input").on('change', function() {
    exchangeRate = $('#exchangeRate').val();
    totalQuantity = 0;
    totalGrossMass = 0;
    totalNetMass = 0;
    totalStatisticalValue = 0;
    totalVatValue = 0;
    $("#pains").find("input").each(function() {
      totalQuantity += parseInt(this.value);
      totalGrossMass += parseFloat($(this).attr("grossMass")) * parseInt(this.value);
      totalNetMass += parseFloat($(this).attr("netMass")) * parseInt(this.value);
      totalStatisticalValue += parseFloat($(this).attr("statisticalValue")) * parseInt(this.value);
    });
    totalStatisticalValue *= parseFloat(exchangeRate);
    totalStatisticalValue = Math.floor(totalStatisticalValue);
    totalVatValue = totalStatisticalValue + 3;
    $("tr[description^=Pains]").find(".grossMass input").val(totalGrossMass.toFixed(2));
    $("tr[description^=Pains]").find(".netMass input").val(totalNetMass.toFixed(2));
    $("tr[description^=Pains]").find(".statisticalValue input").val(totalStatisticalValue);
    $("tr[description^=Pains]").find(".vatValue input").val(totalVatValue);
    $("tr[description^=Pains]").find(".quantity input").val(totalQuantity);

  });
  $('.quantity input').on('change', function() {
    grossMassUnit = $(this.closest("tr")).attr("grossMass");
    netMassUnit = $(this.closest("tr")).attr("netMass");
    statisticalValueUnit = $(this.closest("tr")).attr("statisticalValue");
    exchangeRate = $('#exchangeRate').val();
    quantity = this.value;

    grossMass = parseFloat(grossMassUnit) * quantity;
    netMass = parseFloat(netMassUnit) * quantity;
    statisticalValue = parseFloat(statisticalValueUnit) * quantity * parseFloat(exchangeRate);
    statisticalValue = Math.floor(statisticalValue);
    vatValue = statisticalValue + 3;

    $(this.closest("tr")).find(".grossMass input").val(grossMass.toFixed(2));
    $(this.closest("tr")).find(".netMass input").val(netMass.toFixed(2));
    $(this.closest("tr")).find(".statisticalValue input").val(statisticalValue);
    $(this.closest("tr")).find(".vatValue input").val(vatValue);
  });

});


function exporter() {
  var items = "";


  if ($('#exchangeRate').val() != "" && $('#transportationType option:selected').val() != "" && $('#transportationNumber').val() != "") {

    $('.item input[type=checkbox]:checked').each(function(index) {

      if ($(this.closest("tr")).find(".preference input[type=checkbox]:checked").length == 0) {
        documentReferenceNumber = "";
        documentType = "";
        issueDate = "";
      } else {
        documentReferenceNumber = '<documentReferenceNumber>' + $("#documentReferenceNumber").val() + '</documentReferenceNumber>';
        documentType = 862 //Déclaration d'origine
        issueDate = '<issueDate class="com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl">' +
          '<year>' + $("#issueDate").val().substr(0, 4) + '</year>' +
          '<month>' + $("#issueDate").val().substr(5, 2).replace(/\b0/g, '') + '</month>' +
          '<day>' + $("#issueDate").val().substr(8, 2).replace(/\b0/g, '') + '</day>' +
          '<timezone>-2147483648</timezone>' +
          '<hour>-2147483648</hour>' +
          '<minute>-2147483648</minute>' +
          '<second>-2147483648</second>' +
          '</issueDate>';
      }

      items += '<GoodsItemType>' +
        '<traderItemID>' + index + '</traderItemID>' +
        '<description>' + $(this.closest("tr")).attr("description") + '</description>' +
        '<commodityCode>' + $(this.closest("tr")).attr("commodityCode") + '</commodityCode>' +
        '<statisticalCode>' + $(this.closest("tr")).attr("statisticalCode") + '</statisticalCode>' +
        '<grossMass>' + $(this.closest("tr")).find(".grossMass input").val() + '</grossMass>' +
        '<netMass>' + $(this.closest("tr")).find(".netMass input").val() + '</netMass>' +
        '<permitObligation>' + $(this.closest("tr")).attr("permitObligation") + '</permitObligation>' +
        '<nonCustomsLawObligation>' + $(this.closest("tr")).attr("nonCustomsLawObligation") + '</nonCustomsLawObligation>' +
        '<statistic>' +
        '<customsClearanceType>' + $(this.closest("tr")).attr("customsClearanceType") + '</customsClearanceType>' +
        '<commercialGood>' + $(this.closest("tr")).attr("commercialGood") + '</commercialGood>' +
        '<statisticalValue>' + $(this.closest("tr")).find(".statisticalValue input").val() + '</statisticalValue>' +
        '<repair>0</repair>' +
        '</statistic>' +
        '<origin>' +
        '<originCountry>' + $(this.closest("tr")).attr("originCountry") + '</originCountry>' +
        '<preference>' + $(this.closest("tr")).find(".preference input[type=checkbox]:checked").length + '</preference>' +
        '</origin>' +
        '<packaging>' +
        '<PackagingType>' +
        '<packagingType>' + $(this.closest("tr")).attr("packagingType") + '</packagingType>' +
        '<quantity>' + $(this.closest("tr")).find(".quantity input").val() + '</quantity>' +
        '<packagingReferenceNumber>' + $(this.closest("tr")).attr("packagingReferenceNumber") + '</packagingReferenceNumber>' +
        '</PackagingType>' +
        '</packaging>' +
        '<producedDocument>' +
        '<ProducedDocumentType>' +
        '<documentType>' + documentType + '</documentType>' +
        documentReferenceNumber +
        issueDate +
        '</ProducedDocumentType>' +
        '</producedDocument>' +
        '<valuation>' +
        '<netDuty>0</netDuty>' +
        '<rate>' + $(this.closest("tr")).attr("rate") + '</rate>' +
        '<vatValue>' + $(this.closest("tr")).find(".vatValue input").val() + '</vatValue>' +
        '<vatCode>' + $(this.closest("tr")).attr("vatCode") + '</vatCode>' +
        '</valuation>' +
        '</GoodsItemType>';
    });


    items = items.replace(/\<rate><\/rate\>/g, "");
    items = items.replace(/\<statisticalCode><\/statisticalCode\>/g, "");
    items = items.replace(/\<documentType><\/documentType\>/g, "");
    items = items.replace(/\<ProducedDocumentType><\/ProducedDocumentType\>/g, "");
    items = items.replace(/\<producedDocument><\/producedDocument\>/g, "");

    var xml = '<EdecWeb version="4.0" createdDate="2017-10-26 03:51:42.750 UTC">' +
      '<goodsDeclarationType>' +
      '<serviceType>1</serviceType>' +
      '<declarationType>1</declarationType>' +
      '<language>fr</language>' +
      '<dispatchCountry>FR</dispatchCountry>' +
      '<transportMeans>' +
      '<transportMode>3</transportMode>' +
      '<transportationType>' + $('#transportationType option:selected').val() + '</transportationType>' +
      '<transportationCountry>FR</transportationCountry>' +
      '<transportationNumber>' + $('#transportationNumber').val() + '</transportationNumber>' +
      '</transportMeans>' +
      '<transportInContainer>0</transportInContainer>' +
      '<previousDocument/>' +
      '<importer>' +
      '<name>Le Palmier sarl</name>' +
      '<postalCode>1214</postalCode>' +
      '<city>Vernier</city>' +
      '<country>CH</country>' +
      '<traderIdentificationNumber>CHE485765573</traderIdentificationNumber>' +
      '</importer>' +
      '<consignee>' +
      '<name>Le Palmier sarl</name>' +
      '<postalCode>1214</postalCode>' +
      '<city>Vernier</city>' +
      '<country>CH</country>' +
      '<traderIdentificationNumber>CHE485765573</traderIdentificationNumber>' +
      '</consignee>' +
      '<declarant>' +
      '<traderIdentificationNumber></traderIdentificationNumber>' +
      '<name>Le Palmier sarl</name>' +
      '<street>Route de Peney 51</street>' +
      '<postalCode>1214</postalCode>' +
      '<city>Vernier</city>' +
      '<country>CH</country>' +
      '</declarant>' +
      '<business>' +
      '<customsAccount>0</customsAccount>' +
      '<vatAccount>0</vatAccount>' +
      '<vatSuffix>0</vatSuffix>' +
      '<invoiceCurrencyType>2</invoiceCurrencyType>' +
      '</business>' +
      '<goodsItem>' +
      items +
      '</goodsItem>' +
      '</goodsDeclarationType>' +
      '</EdecWeb>';

    xmlData = vkbeautify.xml(xml);
    $('textarea').val(xmlData);
    enregistrer();
  } else {
    alert("Veuillez remplir tous les champs obligatoires");
  }
}

function enregistrer() {
  var textToWrite = $('textarea').val();
  var textFileAsBlob = new Blob([textToWrite], {
    type: 'text/plain'
  });
  var fileNameToSaveAs = "douane.xml";

  var downloadLink = document.createElement("a");
  downloadLink.download = fileNameToSaveAs;
  downloadLink.innerHTML = "Download File";
  if (window.webkitURL != null) {
    // Chrome allows the link to be clicked without actually adding it to the DOM.
    downloadLink.href = window.webkitURL.createObjectURL(textFileAsBlob);
  } else {
    // Firefox requires the link to be added to the DOM before it can be clicked.
    downloadLink.href = window.URL.createObjectURL(textFileAsBlob);
    downloadLink.onclick = destroyClickedElement;
    downloadLink.style.display = "none";
    document.body.appendChild(downloadLink);
  }

  downloadLink.click();
}

function destroyClickedElement(event) {
  // remove the link from the DOM
  document.body.removeChild(event.target);
}

function createShiftArr(step) {

  var space = '    ';

  if (isNaN(parseInt(step))) { // argument is string
    space = step;
  } else { // argument is integer
    switch (step) {
      case 1:
        space = ' ';
        break;
      case 2:
        space = '  ';
        break;
      case 3:
        space = '   ';
        break;
      case 4:
        space = '    ';
        break;
      case 5:
        space = '     ';
        break;
      case 6:
        space = '      ';
        break;
      case 7:
        space = '       ';
        break;
      case 8:
        space = '        ';
        break;
      case 9:
        space = '         ';
        break;
      case 10:
        space = '          ';
        break;
      case 11:
        space = '           ';
        break;
      case 12:
        space = '            ';
        break;
    }
  }

  var shift = ['\n']; // array of shifts
  for (ix = 0; ix < 100; ix++) {
    shift.push(shift[ix] + space);
  }
  return shift;
}

function vkbeautify() {
  this.step = '    '; // 4 spaces
  this.shift = createShiftArr(this.step);
}

vkbeautify.prototype.xml = function(text, step) {

  var ar = text.replace(/>\s{0,}</g, "><")
    .replace(/</g, "~::~<")
    .replace(/\s*xmlns\:/g, "~::~xmlns:")
    .replace(/\s*xmlns\=/g, "~::~xmlns=")
    .split('~::~'),
    len = ar.length,
    inComment = false,
    deep = 0,
    str = '',
    ix = 0,
    shift = step ? createShiftArr(step) : this.shift;

  for (ix = 0; ix < len; ix++) {
    // start comment or <![CDATA[...]]> or <!DOCTYPE //
    if (ar[ix].search(/<!/) > -1) {
      str += shift[deep] + ar[ix];
      inComment = true;
      // end comment  or <![CDATA[...]]> //
      if (ar[ix].search(/-->/) > -1 || ar[ix].search(/\]>/) > -1 || ar[ix].search(/!DOCTYPE/) > -1) {
        inComment = false;
      }
    } else
      // end comment  or <![CDATA[...]]> //
      if (ar[ix].search(/-->/) > -1 || ar[ix].search(/\]>/) > -1) {
        str += ar[ix];
        inComment = false;
      } else
        // <elm></elm> //
        if (/^<\w/.exec(ar[ix - 1]) && /^<\/\w/.exec(ar[ix]) &&
          /^<[\w:\-\.\,]+/.exec(ar[ix - 1]) == /^<\/[\w:\-\.\,]+/.exec(ar[ix])[0].replace('/', '')) {
          str += ar[ix];
          if (!inComment) deep--;
        } else
          // <elm> //
          if (ar[ix].search(/<\w/) > -1 && ar[ix].search(/<\//) == -1 && ar[ix].search(/\/>/) == -1) {
            str = !inComment ? str += shift[deep++] + ar[ix] : str += ar[ix];
          } else
            // <elm>...</elm> //
            if (ar[ix].search(/<\w/) > -1 && ar[ix].search(/<\//) > -1) {
              str = !inComment ? str += shift[deep] + ar[ix] : str += ar[ix];
            } else
              // </elm> //
              if (ar[ix].search(/<\//) > -1) {
                str = !inComment ? str += shift[--deep] + ar[ix] : str += ar[ix];
              } else
                // <elm/> //
                if (ar[ix].search(/\/>/) > -1) {
                  str = !inComment ? str += shift[deep] + ar[ix] : str += ar[ix];
                } else
                  // <? xml ... ?> //
                  if (ar[ix].search(/<\?/) > -1) {
                    str += shift[deep] + ar[ix];
                  } else
                    // xmlns //
                    if (ar[ix].search(/xmlns\:/) > -1 || ar[ix].search(/xmlns\=/) > -1) {
                      str += shift[deep] + ar[ix];
                    }

    else {
      str += ar[ix];
    }
  }

  return (str[0] == '\n') ? str.slice(1) : str;
}

window.vkbeautify = new vkbeautify();
