/* ------------------
	JS - localStorage
--------------------*/
if (!localStorage.user) {
  window.location.href = 'login.html';
}

$(document).ready(function() {
  if (localStorage.basket) {
    delete localStorage.basket;
  }
  userDisplay();
  basketDisplay();
});

function basketDisplay() {
  if (localStorage.basket) {
    var basket = JSON.parse(localStorage.getItem('basket'));
  } else {
    var basket = [];
  }
  var total = 0;
  var items = "";
  $('.jq-basket-count').html(basket.length);
  $(basket).each(function(index) {
    items += '<li class="dropdown-item">' + '<a class="link-to"></a>' + '<figure class="product-preview-image tiny">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '<p class="text-header tiny">' + this.designation + '</p>' + '<p class="category tiny primary">x ' + this.quantity + '</p>' + '<p class="price tiny">' + parseFloat(this.price * this.quantity).toFixed(2) + '<span> CHF</span></p>' + '</li>';
    total += this.price * this.quantity;
  });
  items += '<li class="dropdown-item">' + '<p class="text-header tiny">Total</p>' + '<p class="price">' + parseFloat(total).toFixed(2) + '<span> CHF</span></p>' + '<a href="cart.html" class="button primary">Aller au panier</a>' + '</li>';
  $('.jq-basket-content').html(items);
}

function userDisplay() {
  var user = JSON.parse(localStorage.getItem('user'));
  $('.jq-username').html(user.username);
  $('.jq-company-name').html(user.companyName);
}

function logout() {
  localStorage.clear();
  window.location.href = 'login.html';
}

/* ------------------
	PHP - session
--------------------*/
/*
var user;
var basket;
  $.ajax({
    url: '../../../bubble/api/session/user',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(response.error) {  
		window.location.href = 'login.html';
	  } else {
		  user = response;
		    userDisplay();

	  }
    }
  })
  $.ajax({
    url: '../../../bubble/api/session/basket',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(!response.error) {  
				  basket = response;

	  } else {
    basket = [];
  }
    basketDisplay();

    }
  })


function basketDisplay() {
  var total = 0;
  var items = "";
  $('.jq-basket-count').html(basket.length);
  $(basket).each(function(index) {
    items += '<li class="dropdown-item">' + '<a class="link-to"></a>' + '<figure class="product-preview-image tiny">' + '<img src="images/items/image' + this.productId + '_s.jpg" alt="">' + '</figure>' + '<p class="text-header tiny">' + this.designation + '</p>' + '<p class="category tiny primary">x ' + this.quantity + '</p>' + '<p class="price tiny"><span>$</span>' + parseFloat(this.price * this.quantity).toFixed(2) + '</p>' + '</li>';
    total += this.price * this.quantity;
  });
  items += '<li class="dropdown-item">' + '<p class="text-header tiny">Total</p>' + '<p class="price"><span>$</span>' + parseFloat(total).toFixed(2) + '</p>' + '<a href="cart.html" class="button primary">Aller au panier</a>' + '</li>';
  $('.jq-basket-content').html(items);
}

function userDisplay() {
  $('.jq-username').html(user.username);
  $('.jq-company-name').html(user.companyName);
}

function logout() {
  $.ajax({
    url: '../../../bubble/api/session/destroy',
    type: 'GET',
    dataType: "json",
    success: function(response) {
      if(response.notice) {  
		window.location.href = 'login.html';
	  }
    }
  })
}
*/